/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.proposals;

import ev.poi.PoissonModel;
import ev.poi.proposals.PoissonProposal;
import java.util.Random;
import nuts.math.Sampling;

public class ParameterProposal
implements PoissonProposal {
    private final double indelMultiplier;
    private final boolean isDelete;
    private double oldValue;
    private final PoissonModel model;

    public ParameterProposal(PoissonModel model, double indelMultiplier, boolean isDelete) {
        this.model = model;
        this.indelMultiplier = indelMultiplier;
        this.isDelete = isDelete;
    }

    @Override
    public double doProposal(Random rand, boolean maximize) {
        if (this.indelMultiplier <= 1.0) {
            throw new RuntimeException();
        }
        this.oldValue = this.isDelete ? this.model.getCalculator().params.deleteRate : this.model.getCalculator().params.insertRate;
        double m = Sampling.nextDouble(rand, 1.0 / this.indelMultiplier, this.indelMultiplier);
        double newValue = m * this.oldValue;
        if (this.isDelete) {
            this.model.setDeleteRate(newValue);
        } else {
            this.model.setInsertRate(newValue);
        }
        return Math.log(m);
    }

    @Override
    public void undo() {
        if (this.isDelete) {
            this.model.setDeleteRate(this.oldValue);
        } else {
            this.model.setInsertRate(this.oldValue);
        }
    }

    @Override
    public String description() {
        return "" + (this.isDelete ? "Delete" : "Insert") + "ParameterProposal";
    }
}

