/*
 * Decompiled with CFR 0.152.
 */
package fenchel.tests;

import fenchel.factor.multisitecat.MSCFactorGraph;
import fenchel.factor.multisitecat.MSCUnaryScaledFactor;
import fig.basic.UnorderedPair;
import nuts.math.GMFct;
import nuts.math.Graphs;

public class CompareMSCToGM {
    public static <N> void setPotentials(GMFct<N> gm, MSCFactorGraph<N> fg) {
        CompareMSCToGM.setBinaryPotentials(gm, fg);
        CompareMSCToGM.setUnaryPotentials(gm, fg);
    }

    public static <N> void setBinaryPotentials(GMFct<N> gm, MSCFactorGraph<N> fg) {
        for (UnorderedPair<N, N> key : Graphs.edgeSet(gm.graph())) {
            N n1 = key.getFirst();
            N n2 = key.getSecond();
            for (int s1 = 0; s1 < gm.nStates(n1); ++s1) {
                for (int s2 = 0; s2 < gm.nStates(n2); ++s2) {
                    fg.setBinary(0, n1, s1, n2, s2, gm.get(n1, n2, s1, s2));
                }
            }
        }
    }

    public static <N> void setUnaryPotentials(GMFct<N> gm, MSCFactorGraph<N> fg) {
        for (N node : gm.graph().vertexSet()) {
            MSCUnaryScaledFactor factor = fg.getMSCUnary(node);
            for (int s1 = 0; s1 < gm.nStates(node); ++s1) {
                factor.set(0, 0, s1, gm.get(node, s1));
            }
        }
    }
}

