/*
 * Decompiled with CFR 0.152.
 */
package marking;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marking.FinalGrade;
import nuts.io.IO;
import nuts.math.PlotHistogram;
import nuts.math.StatisticsMap;
import nuts.util.Counter;

public class FinalGradesStat547Fall2013
implements Runnable {
    Map<String, Double> letterValues = Maps.newHashMap();
    @Option
    public double finalExamCurve;

    public FinalGradesStat547Fall2013() {
        this.letterValues.put("A+", 1.0);
        this.letterValues.put("A", 0.89);
        this.letterValues.put("A-", 0.84);
        this.letterValues.put("B+", 0.79);
        this.letterValues.put("B", 0.75);
        this.finalExamCurve = 0.7;
    }

    public static void main(String[] args) {
        IO.run(args, new FinalGradesStat547Fall2013());
    }

    @Override
    public void run() {
        HashMap maxScore = Maps.newHashMap();
        HashMap wei = Maps.newHashMap();
        for (Map<String, String> fields : IO.iCSVMap("/Users/bouchard/Documents/courses/stat547-fa2013-14/marking/weights.csv")) {
            maxScore.put(fields.get("activity"), Double.parseDouble(fields.get("maxScore")));
            wei.put(fields.get("activity"), Double.parseDouble(fields.get("weight")));
        }
        HashMap failures = Maps.newHashMap();
        HashMap grades = Maps.newHashMap();
        LogInfo.logs("maxScores = " + maxScore);
        LogInfo.logs("weights = " + wei);
        Counter<String> letterGradeHist = new Counter<String>();
        int nFails = 0;
        PlotHistogram hist = new PlotHistogram();
        StatisticsMap.DescriptiveStatisticsMap<String> statistics = new StatisticsMap.DescriptiveStatisticsMap<String>();
        ArrayList ids = Lists.newArrayList();
        for (Map<String, String> fields : IO.iCSVMap("/Users/bouchard/Documents/courses/stat547-fa2013-14/marking/ALL_GRADES.csv")) {
            String id = fields.get("Student Number");
            if (id == null) continue;
            LogInfo.track("Compiling grade for " + id);
            ids.add(id);
            double studentSum = 0.0;
            for (String activity : maxScore.keySet()) {
                String currentLog = activity + " : ";
                String fieldStr = fields.get(activity);
                currentLog = currentLog + fieldStr;
                boolean capNorm = true;
                if (!fieldStr.matches("\\s*[0-9.]*\\s*")) {
                    capNorm = false;
                    fieldStr = "" + this.letterValues.get(fieldStr);
                    currentLog = currentLog + " -translate-> " + fieldStr;
                }
                double fieldValue = fieldStr == null || "".equals(fieldStr) ? 0.0 : Double.parseDouble(fieldStr);
                currentLog = currentLog + " -parse-> " + fieldValue;
                if (capNorm) {
                    double max = (Double)maxScore.get(activity);
                    fieldValue = Math.min(max, fieldValue);
                    currentLog = currentLog + " -cap-> " + fieldValue + "/" + max;
                    currentLog = currentLog + " -norm-> " + (fieldValue /= max);
                }
                statistics.addValue(activity, fieldValue);
                studentSum += (Double)wei.get(activity) * fieldValue;
                LogInfo.logsForce(currentLog);
            }
            double studentGrade = studentSum;
            if (studentGrade <= 0.5 && studentGrade >= 0.485) {
                studentGrade = 0.5;
                LogInfo.logsForce("Rounding up 48.5 to 50");
            }
            letterGradeHist.incrementCount(FinalGrade.letterGrade(studentGrade), 1.0);
            grades.put(id, studentGrade);
            LogInfo.logsForce("student-total = " + studentGrade);
            statistics.addValue("TOTAL", studentGrade);
            hist.addPoint(studentGrade);
            if (studentGrade < 0.5) {
                ++nFails;
                failures.put(id, "" + studentGrade);
            }
            LogInfo.end_track();
        }
        LogInfo.logs("nStudents = " + ids.size());
        LogInfo.logsForce(statistics.printAll() + "\n");
        LogInfo.logsForce("nFails = " + nFails + " " + failures);
        LogInfo.logsForce("curveValue = " + this.finalExamCurve);
        hist.savePlot(new File(Execution.getFile("hist.pdf")));
        LogInfo.track("Grade hist (unnorm)");
        for (String key : FinalGrade.allLetterGrades) {
            LogInfo.logsForce(key + "\t" + letterGradeHist.getCount(key));
        }
        LogInfo.end_track();
        letterGradeHist.normalize();
        LogInfo.track("Grade hist");
        for (String key : FinalGrade.allLetterGrades) {
            LogInfo.logsForce(key + "\t" + letterGradeHist.getCount(key));
        }
        LogInfo.end_track();
        PrintWriter out = IOUtils.openOutEasy(Execution.getFile("stat547-to-upload.csv"));
        boolean first = true;
        for (List<String> line : IO.iCSV("/Users/bouchard/Documents/courses/stat547-fa2013-14/marking/final-grades-template.csv")) {
            line = new ArrayList<String>(line);
            if (!first) {
                String id = line.get(3);
                if (id == null || "".equals(id)) continue;
                double grade = (Double)grades.get(id) * 100.0;
                line.add(15, "" + grade);
            }
            out.println(StrUtils.join(line, ","));
            first = false;
        }
        out.close();
    }

    private double curve(double fieldValue) {
        if (fieldValue == 0.0) {
            return 0.0;
        }
        double result = Math.pow(fieldValue, this.finalExamCurve);
        return result;
    }
}

