/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import nuts.io.IO;
import nuts.remote.ExecuteLaunchPad;
import nuts.remote.LaunchLargeExperiment;
import nuts.tui.Utils;
import nuts.util.CollUtils;

public class GetAllRemoteResults
implements Runnable {
    @Option
    public boolean killAfterDownload = false;
    @Option
    public ArrayList<String> filters = new ArrayList<String>(Arrays.asList(""));

    public static void main(String[] args) {
        IO.run(args, new GetAllRemoteResults());
    }

    @Override
    public void run() {
        ArrayList<String> selectedExecs = CollUtils.list();
        for (String exec : IO.f2l(LaunchLargeExperiment.LAUNCH_EXECS)) {
            if (exec.matches("^\\s*$")) continue;
            boolean match = false;
            for (String filter : this.filters) {
                if (!exec.contains(filter)) continue;
                match = true;
            }
            if (!match) continue;
            selectedExecs.add(exec);
        }
        LogInfo.logs("Selected execs: " + StrUtils.join(selectedExecs, ", "));
        if (this.killAfterDownload && !"y".equals(Utils.hardPrompt("Confirm kill remote? [y/n] "))) {
            return;
        }
        for (String exec : selectedExecs) {
            LogInfo.track("Processing: " + exec);
            String result = ExecuteLaunchPad.launch("nuts.remote.GetRemoteResults -killAfterDownload " + this.killAfterDownload + " -launchExec " + exec);
            LogInfo.logs(result);
            LogInfo.end_track();
        }
    }
}

