/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.ListUtils;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import nuts.io.IO;

public class Bin {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Bin <file> <nBins>");
            return;
        }
        int nBins = Integer.parseInt(args[1]);
        ArrayList<Pair<Double, Double>> pts = new ArrayList<Pair<Double, Double>>();
        for (String line : IO.i(args[0])) {
            String[] fs = line.split("\\t");
            pts.add(Pair.makePair(Double.parseDouble(fs[0]), Double.parseDouble(fs[1])));
        }
        Comparator<Pair<Double, Double>> comp = new Comparator<Pair<Double, Double>>(){

            @Override
            public int compare(Pair<Double, Double> arg0, Pair<Double, Double> arg1) {
                return arg0.getFirst().compareTo(arg1.getFirst());
            }
        };
        Collections.shuffle(pts);
        Collections.sort(pts, comp);
        double min = (Double)((Pair)pts.get(0)).getFirst();
        double max = (Double)((Pair)ListUtils.getLast(pts)).getFirst();
        double binLength = (max - min) / (double)nBins;
        int binSize = pts.size() / nBins;
        double num = 0.0;
        double denom = 0.0;
        int nPoints = 0;
        int cBin = 1;
        for (int i = 0; i < pts.size(); ++i) {
            Pair pt = (Pair)pts.get(i);
            num += ((Double)pt.getSecond()).doubleValue();
            denom += 1.0;
            ++nPoints;
            if (!((Double)pt.getFirst() > min + binLength * (double)cBin) && i != pts.size() - 1) continue;
            ++cBin;
            nPoints = 0;
            System.out.println("" + pt.getFirst() + "\t" + num / denom);
            denom = 0.0;
            num = 0.0;
        }
    }
}

