/*
 * Decompiled with CFR 0.152.
 */
package poly;

import functional.Fct;
import poly.CmpxPoly;
import poly.Complex;

public class DurantKerner {
    private final Fct<Complex, Complex> p;
    private final int degree;
    private static double xInit = 0.4;
    private static double yInit = 0.9;

    public DurantKerner(Fct<Complex, Complex> p, int degree) {
        this.p = p;
        this.degree = degree;
    }

    public Complex[] findRoots() {
        Complex[] oldEstimate = this.init();
        Complex[] newEstimate = null;
        for (int i = 0; i < 100 && !this.converged(newEstimate = this.update(oldEstimate), oldEstimate); ++i) {
            oldEstimate = newEstimate;
        }
        return newEstimate;
    }

    private Complex[] init() {
        Complex[] result = new Complex[this.degree];
        result[0] = Complex.plusOne();
        for (int d = 1; d < this.degree; ++d) {
            result[d] = Complex.times(result[d - 1], new Complex(xInit, yInit));
        }
        return result;
    }

    private Complex[] update(Complex[] oldValue) {
        Complex[] result = Complex.copy(oldValue);
        oldValue = null;
        for (int d = 0; d < this.degree; ++d) {
            Complex eval = this.p.applyTo(result[d]);
            Complex quotient = Complex.plusOne();
            for (int e = 0; e < this.degree; ++e) {
                if (e == d) continue;
                Complex diff = Complex.minus(result[d], result[e]);
                quotient = Complex.times(quotient, diff);
            }
            result[d] = Complex.minus(result[d], Complex.over(eval, quotient));
        }
        return result;
    }

    private boolean converged(Complex[] newEstimate, Complex[] oldEstimate) {
        return false;
    }

    public static void main(String[] args) {
        Complex[] coef = new Complex[]{new Complex(-5.0), new Complex(3.0), new Complex(-3.0), new Complex(1.0), new Complex(-5.0), new Complex(3.0), new Complex(-3.0), new Complex(1.0), new Complex(-5.0), new Complex(3.0), new Complex(-3.0), new Complex(1.0)};
        CmpxPoly poly = new CmpxPoly(coef);
        DurantKerner kd = new DurantKerner(poly, poly.degree());
        Complex[] roots = kd.findRoots();
        for (int i = 0; i < roots.length; ++i) {
            System.out.println("" + roots[i] + " : " + poly.applyTo(roots[i]));
        }
    }
}

