/*
 * Decompiled with CFR 0.152.
 */
package practice;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import nuts.io.IO;

public class RandomSentence
implements Runnable {
    @Option(required=true)
    public static String grammarPath;
    @Option(required=true)
    public int numSentences;
    @Option(required=true)
    public Random rand = new Random(1L);
    public static HashMap<String, Rules> grammar;

    @Override
    public void run() {
        try {
            String rule;
            BufferedReader reader = IOUtils.openIn(grammarPath);
            while ((rule = reader.readLine()) != null) {
                if (rule.length() == 0 || rule.charAt(0) == '#') continue;
                String[] components = rule.split("\t");
                int sharpIndex = components[2].indexOf(35);
                String RHS = components[2].substring(0, sharpIndex == -1 ? components[2].length() : sharpIndex);
                if (grammar.containsKey(components[1])) {
                    grammar.get(components[1]).addRule(RHS.toString(), Integer.parseInt(components[0]));
                    continue;
                }
                Rules rules = new Rules(components[1], RHS.toString(), Integer.parseInt(components[0]));
                grammar.put(components[1], rules);
            }
        }
        catch (IOException e) {
            LogInfo.logs(e);
        }
        for (int i = 0; i < this.numSentences; ++i) {
            Stack<String> stack = new Stack<String>();
            stack.push("ROOT");
            StringBuilder sentence = new StringBuilder();
            block4: while (!stack.isEmpty()) {
                String token = (String)stack.pop();
                if (!grammar.containsKey(token)) {
                    sentence.append(token + " ");
                    continue;
                }
                Rules rules = grammar.get(token);
                Rule sampled = rules.sample();
                String[] split = sampled.rule.split("\\s");
                for (int s = split.length - 1; s >= 0; --s) {
                    if (split[s].trim().length() == 0) continue;
                    if (split[s].trim().charAt(0) == '#') continue block4;
                    stack.push(split[s]);
                }
            }
            LogInfo.logs("Sentence " + (i + 1) + ": " + sentence.toString());
        }
    }

    public static void main(String[] args) {
        IO.run(args, new RandomSentence());
    }

    static {
        grammar = new HashMap();
    }

    public class Rules {
        int total;
        ArrayList<Rule> rules = new ArrayList();
        String LHS;

        public Rules(String lhs, String rhs, int count) {
            this.total = count;
            this.LHS = lhs;
            this.rules.add(new Rule(rhs, count));
        }

        public void addRule(String rhs, int count) {
            this.total += count;
            this.rules.add(new Rule(rhs, count));
        }

        public Rule sample() {
            int sample = RandomSentence.this.rand.nextInt(this.total);
            int sum = 0;
            for (Rule rule : this.rules) {
                if (sample >= (sum += rule.count)) continue;
                return rule;
            }
            throw new RuntimeException();
        }
    }

    public class Rule {
        int count;
        String rule;

        public Rule(String rule, int count) {
            this.rule = rule;
            this.count = count;
        }
    }
}

