/*
 * Decompiled with CFR 0.152.
 */
package pty;

import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import pty.RandomRootedTrees;
import pty.RootedTree;
import pty.UnrootedTree;

public class RandomUnrootedTrees {
    public static UnrootedTree sampleExponentialBranchesUniformTopology(Random rand, int nTaxa, double rate) {
        return RandomUnrootedTrees.sampleExponentialBranchesUniformTopology(rand, RandomRootedTrees.generateLeafNames(nTaxa), rate);
    }

    public static UnrootedTree sampleExponentialBranchesUniformTopology(Random rand, Collection<Taxon> taxa, double rate) {
        RootedTree coal = RandomRootedTrees.sampleCoalescent(rand, taxa, rate);
        UnrootedTree rooted = UnrootedTree.fromRooted(coal);
        HashMap<UnorderedPair<Taxon, Taxon>, Double> newBLs = CollUtils.map();
        for (UnorderedPair<Taxon, Taxon> key : rooted.edges()) {
            newBLs.put(key, Sampling.sampleExponential(rand, 1.0 / rate));
        }
        return new UnrootedTree(rooted.getTopology(), newBLs);
    }
}

