/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.models;

import java.util.ArrayList;
import java.util.List;
import nuts.util.CollUtils;
import pty.smc.models.LikelihoodModelCalculator;

public class ProductModel
implements LikelihoodModelCalculator {
    private final List<LikelihoodModelCalculator> subModels;

    public ProductModel(List<LikelihoodModelCalculator> subModels) {
        this.subModels = CollUtils.archive(subModels);
    }

    @Override
    public LikelihoodModelCalculator combine(LikelihoodModelCalculator _node1, LikelihoodModelCalculator _node2, double delta1, double delta2, boolean doNotBuildCache) {
        ProductModel node1 = (ProductModel)_node1;
        ProductModel node2 = (ProductModel)_node2;
        ArrayList<LikelihoodModelCalculator> subModels = CollUtils.list();
        int size = node1.subModels.size();
        if (size != node2.subModels.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < size; ++i) {
            subModels.add(node1.subModels.get(i).combine(node1.subModels.get(i), node2.subModels.get(i), delta1, delta2, doNotBuildCache));
        }
        return new ProductModel(subModels);
    }

    @Override
    public double extendLogLikelihood(double delta) {
        double sum = 0.0;
        for (LikelihoodModelCalculator lmc : this.subModels) {
            sum += lmc.extendLogLikelihood(delta);
        }
        return sum;
    }

    @Override
    public boolean isReversible() {
        for (LikelihoodModelCalculator lmc : this.subModels) {
            if (lmc.isReversible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double logLikelihood() {
        double sum = 0.0;
        for (LikelihoodModelCalculator lmc : this.subModels) {
            sum += lmc.logLikelihood();
        }
        return sum;
    }

    @Override
    public double peekCoalescedLogLikelihood(LikelihoodModelCalculator _node1, LikelihoodModelCalculator _node2, double delta1, double delta2) {
        double sum = 0.0;
        ProductModel node1 = (ProductModel)_node1;
        ProductModel node2 = (ProductModel)_node2;
        int size = node1.subModels.size();
        if (size != node2.subModels.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < size; ++i) {
            sum += node1.subModels.get(i).peekCoalescedLogLikelihood(node1.subModels.get(i), node2.subModels.get(i), delta1, delta2);
        }
        return sum;
    }
}

