/*
 * Decompiled with CFR 0.152.
 */
package sage;

import goblin.CognateId;
import goblin.CognateSet;
import goblin.DerivationTree;
import goblin.HLParams;
import goblin.HLParamsUpdater;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.Tree;
import sage.FatGenerator;
import sage.LikelihoodModel;

public class Fat2HLPrj {
    public int nTrees = 10;
    public Random rand = new Random(1L);

    public HLParams project(LikelihoodModel.FatLikelihoodModel flm, HLParamsUpdater hpu, Map<CognateId, Tree<String>> ts) {
        FatGenerator fg = new FatGenerator(flm);
        Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> suffStats = new Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>>();
        for (CognateId id : ts.keySet()) {
            for (int i = 0; i < this.nTrees; ++i) {
                Arbre<DerivationTree.DerivationNode> a = fg.generate(ts.get(id), this.rand, id);
                HLParams.addSuffStats(suffStats, a, flm.getEncodings());
            }
        }
        return hpu.update(suffStats);
    }

    public static Map<CognateId, Tree<String>> cognateSet2Trees(CognateSet cs) {
        HashMap<CognateId, Tree<String>> result = new HashMap<CognateId, Tree<String>>();
        for (CognateId id : cs.getCognateIds()) {
            result.put(id, Fat2HLPrj.convert(cs.getTree(id)));
        }
        return result;
    }

    public static Tree<String> convert(Arbre<DerivationTree.DerivationNode> tree) {
        Tree<String> result = new Tree<String>(tree.getContents().getLanguage().toString());
        for (Arbre<DerivationTree.DerivationNode> st : tree.getChildren()) {
            result.getChildren().add(Fat2HLPrj.convert(st));
        }
        return result;
    }
}

