/*
 * Decompiled with CFR 0.152.
 */
package smc;

import java.io.Serializable;

public abstract class Particle<S>
implements Serializable {
    private long uid;
    private int machine;
    protected double weight = -1.0;
    protected int[] machines = null;
    private static long ID_ASSIGNER = 1L;
    public static int numMachines = 1;

    public Particle(int machine) {
        this.uid = ID_ASSIGNER++;
        this.machine = machine;
        this.machines = new int[numMachines];
    }

    public Particle(long uid, int machine) {
        this.uid = uid;
        this.machine = machine;
        this.machines = new int[numMachines];
    }

    public long getUniqueId() {
        return this.uid;
    }

    public void addMachine(int machine) {
        int n = machine;
        this.machines[n] = this.machines[n] + 1;
    }

    public int[] getMachines() {
        return this.machines;
    }

    public String machinesString() {
        StringBuffer sb = new StringBuffer();
        int[] nArray = this.machines;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer machine = nArray[i];
            sb.append(machine + " ");
        }
        return sb.toString();
    }

    public void setMachine(int machine) {
        this.machine = machine;
    }

    public int getMachine() {
        return this.machine;
    }

    public String getMachinesString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numMachines; ++i) {
            sb.append(i + " " + this.machines[i] + " times; ");
        }
        return sb.toString();
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public abstract S getSample();

    public abstract Particle<S> setSample(S var1, double var2);

    public abstract Particle<S> getParent();

    public abstract void setCompactParticle(long var1, Particle<S> var3);
}

