/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.WebLink;
import org.forester.phylogeny.data.NodeVisualization;
import org.forester.util.ForesterUtil;

public final class Configuration {
    static final String VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA = "validate_against_phyloxml_xsd_schema";
    private static final String WEB_LINK_KEY = "web_link";
    private static final String DISPLAY_COLOR_KEY = "display_color";
    private static final int DEPRECATED = -2;
    private UI _ui = UI.UNKNOWN;
    private boolean _use_tabbed_display = false;
    private boolean _hide_controls_and_menus = false;
    private Options.CLADOGRAM_TYPE _cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
    private File _mafft = null;
    private File _clustalo = null;
    private File _fastme = null;
    private SortedMap<String, WebLink> _weblinks = null;
    private SortedMap<String, Color> _display_colors = null;
    private boolean _antialias_screen = true;
    private Options.PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private String _base_font_family_name = "";
    private int _base_font_size = -1;
    private int _graphics_export_x = -1;
    private int _graphics_export_y = -1;
    private short _ov_max_width = (short)80;
    private short _ov_max_height = (short)80;
    private Options.OVERVIEW_PLACEMENT_TYPE _ov_placement = Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
    private double _min_confidence_value = 0.0;
    private float _print_line_width = 0.5f;
    private boolean _show_scale = false;
    private boolean _show_branch_length_values = false;
    private boolean _show_overview = true;
    private short _number_of_digits_after_comma_for_confidence_values = 1;
    private short _number_of_digits_after_comma_for_branch_length_values = (short)2;
    private boolean _editable = true;
    private boolean _nh_parsing_replace_underscores = false;
    private boolean _nh_parsing_extract_pfam_taxonomy_codes = false;
    private boolean _internal_number_are_confidence_for_nh_parsing = false;
    private boolean _display_sequence_relations = false;
    private boolean _validate_against_phyloxml_xsd_schema = true;
    private boolean _background_color_gradient = false;
    private boolean _show_domain_labels = true;
    private boolean _abbreviate_scientific_names = false;
    private boolean _color_labels_same_as_parent_branch = false;
    private int _default_bootstrap_samples = -1;
    private boolean _show_default_node_shapes = false;
    private NodeVisualization.NodeShape _default_node_shape = NodeVisualization.NodeShape.CIRCLE;
    private NodeVisualization.NodeFill _default_node_fill = NodeVisualization.NodeFill.GRADIENT;
    private short _default_node_shape_size = (short)6;
    private boolean _taxonomy_colorize_node_shapes = false;
    static final int display_as_phylogram = 0;
    static final int show_node_names = 1;
    static final int show_tax_code = 2;
    static final int show_annotation = 3;
    static final int write_confidence_values = 4;
    static final int write_events = 5;
    static final int color_according_to_species = 6;
    static final int color_branches = 7;
    static final int width_branches = 8;
    static final int show_custom_node_shapes = 9;
    static final int show_domain_architectures = 10;
    static final int show_binary_characters = 11;
    static final int show_binary_character_counts = 12;
    static final int show_gene_names = 13;
    static final int show_sequence_acc = 14;
    static final int display_internal_data = 15;
    static final int dynamically_hide_data = 16;
    static final int show_taxonomy_scientific_names = 17;
    static final int show_taxonomy_common_names = 18;
    static final int color_according_to_annotation = 19;
    static final int show_gene_symbols = 20;
    static final int node_data_popup = 21;
    static final int show_relation_confidence = 22;
    static final int show_vector_data = 23;
    static final int show_taxonomy_images = 24;
    static final int show_properties = 25;
    static final int display_node_data = 0;
    static final int collapse_uncollapse = 1;
    static final int reroot = 2;
    static final int subtree = 3;
    static final int swap = 4;
    static final int color_subtree = 5;
    static final int open_seq_web = 6;
    static final int open_tax_web = 7;
    static final int blast = 8;
    static final int cut_subtree = 9;
    static final int copy_subtree = 10;
    static final int paste_subtree = 11;
    static final int delete_subtree_or_node = 12;
    static final int add_new_node = 13;
    static final int edit_node_data = 14;
    static final int sort_descendents = 15;
    String config_filename;
    String default_config_filename = "_aptx_configuration_file";
    static final String[][] display_options = new String[][]{{"Phylogram", "display", "?"}, {"Node Name", "display", "yes"}, {"Taxonomy Code", "display", "yes"}, {"Annotation", "nodisplay", "no"}, {"Confidence Values", "display", "?"}, {"Event", "display", "?"}, {"Taxonomy Colorize", "display", "no"}, {"Colorize Branches", "display", "no"}, {"Use Branch-Widths", "display", "no"}, {"Show Custom Nodes", "display", "yes"}, {"Domains", "nodisplay", "no"}, {"Binary Characters", "nodisplay", "no"}, {"Binary Char Counts", "nodisplay", "no"}, {"Prot/Gene Name", "display", "yes"}, {"Prot/Gene Acc", "display", "no"}, {"Show Internal Data", "display", "yes"}, {"Dyna Hide", "display", "yes"}, {"Taxonomy Scientific", "display", "yes"}, {"Taxonomy Common", "display", "no"}, {"Annotation Colorize", "nodisplay", "no"}, {"Prot/Gene Symbol", "display", "yes"}, {"Rollover", "display", "yes"}, {"Relation Confidence", "display", "no"}, {"Vector Data", "display", "no"}, {"Taxonomy Images", "display", "no"}, {"Properties", "display", "no"}};
    static final String[][] clickto_options = new String[][]{{"Display Node Data", "display"}, {"Collapse/Uncollapse", "display"}, {"Root/Reroot", "display"}, {"Sub/Super Tree", "display"}, {"Swap Descendants", "display"}, {"Colorize Subtree", "display"}, {"Open Sequence Web", "display"}, {"Open Taxonomy Web", "display"}, {"Blast", "display"}, {"Cut Subtree", "display"}, {"Copy Subtree", "display"}, {"Paste Subtree", "display"}, {"Delete Subtree/Node", "display"}, {"Add New Node", "display"}, {"Edit Node Data", "display"}, {"Sort Descendants", "display"}};
    int default_clickto = 0;
    TreeColorSet tree_color_set;
    TreeFontSet tree_font_set;
    private static Hashtable<String, Color> _species_colors;
    private static Hashtable<String, Color> _domain_colors;
    private static Hashtable<String, Color> _annotation_colors;
    boolean verbose = false;
    private Options.NODE_LABEL_DIRECTION _node_label_direction = Options.NODE_LABEL_DIRECTION.HORIZONTAL;
    private Color _gui_background_color = Constants.GUI_BACKGROUND_DEFAULT;
    private Color _gui_checkbox_text_color = Constants.CHECKBOX_TEXT_COLOR_DEFAULT;
    private Color _gui_checkbox_and_button_active_color = Constants.CHECKBOX_AND_BUTTON_ACTIVE_COLOR_DEFAULT;
    private Color _gui_button_text_color = Constants.BUTTON_TEXT_COLOR_DEFAULT;
    private Color _gui_button_background_color = Constants.BUTTON_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_menu_background_color = Constants.MENU_BACKGROUND_COLOR_DEFAULT;
    private Color _gui_menu_text_color = Constants.MENU_TEXT_COLOR_DEFAULT;
    private Color _gui_button_border_color = Constants.BUTTON_BORDER_COLOR_DEFAULT;
    private Color _domain_structure_font_color = Constants.DOMAIN_STRUCTURE_FONT_COLOR_DEFAULT;
    private Color _domain_structure_base_color = Constants.DOMAIN_STRUCTURE_BASE_COLOR_DEFAULT;
    private static String DEFAULT_FONT_FAMILY;

    public Configuration() {
        this(null, false, false, false);
    }

    public Configuration(String string, boolean bl, boolean bl2, boolean bl3) {
        this.config_filename = ForesterUtil.isEmpty(string) ? this.default_config_filename : string;
        this.setWebLinks(new TreeMap<String, WebLink>());
        this.setDisplayColors(new TreeMap<String, Color>());
        this.config_filename = this.config_filename.trim();
        URL uRL = null;
        if (bl) {
            try {
                uRL = new URL(this.config_filename);
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    this.readConfig(bufferedReader);
                    bufferedReader.close();
                    ForesterUtil.programMessage("Archaeopteryx", "successfully read from configuration url [" + this.config_filename + "]");
                }
                catch (Exception exception) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + exception.getLocalizedMessage());
                }
            }
            catch (Exception exception) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration url [" + this.config_filename + "]");
            }
        } else {
            File file = new File(this.config_filename);
            if (!file.exists()) {
                file = new File(this.config_filename + ".txt");
            }
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    this.readConfig(bufferedReader);
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (bl3) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "failed to read configuration from [" + this.config_filename + "]: " + exception);
                    }
                }
            } else if (bl3) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "cannot find or open configuration file [" + this.config_filename + "]");
            }
        }
    }

    private void createWebLink(String string, String string2, String string3) {
        WebLink webLink = null;
        boolean bl = false;
        try {
            webLink = new WebLink(new URL(string.trim()), string2.trim(), string3.trim());
        }
        catch (MalformedURLException malformedURLException) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not create URL from [" + string + "]");
            bl = true;
        }
        if (!bl && webLink != null) {
            this.getWebLinks().put(webLink.getSourceIdentifier().toLowerCase(), webLink);
        }
    }

    boolean displaySequenceRelations() {
        return this._display_sequence_relations;
    }

    boolean doCheckOption(int n) {
        return display_options[n][2].equalsIgnoreCase("yes") || display_options[n][2].equalsIgnoreCase("true");
    }

    boolean doDisplayClickToOption(int n) {
        return clickto_options[n][1].equalsIgnoreCase("display");
    }

    boolean doDisplayOption(int n) {
        return display_options[n][1].equalsIgnoreCase("display");
    }

    boolean doGuessCheckOption(int n) {
        return display_options[n][2].equals("?");
    }

    Map<String, Color> getAnnotationColors() {
        if (_annotation_colors == null) {
            _annotation_colors = new Hashtable();
        }
        return _annotation_colors;
    }

    public String getBaseFontFamilyName() {
        return this._base_font_family_name;
    }

    int getBaseFontSize() {
        return this._base_font_size;
    }

    Options.CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    private int getClickToIndex(String string) {
        int n = -1;
        if (string.equals("edit_info")) {
            n = 0;
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [edit_info] is deprecated, use [display node data] instead");
        } else if (string.equals("display_node_data")) {
            n = 0;
        } else if (string.equals("collapse_uncollapse")) {
            n = 1;
        } else if (string.equals("reroot")) {
            n = 2;
        } else if (string.equals("subtree")) {
            n = 3;
        } else if (string.equals("swap")) {
            n = 4;
        } else if (string.equals("sort_descendants")) {
            n = 15;
        } else {
            if (string.equals("display_sequences")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_sequences] is deprecated");
                return -2;
            }
            if (string.equals("open_seq_web")) {
                n = 6;
            } else if (string.equals("open_tax_web")) {
                n = 7;
            } else if (string.equals("blast")) {
                n = 8;
            } else if (string.equals("cut_subtree")) {
                n = 9;
            } else if (string.equals("copy_subtree")) {
                n = 10;
            } else if (string.equals("paste_subtree")) {
                n = 11;
            } else if (string.equals("delete")) {
                n = 12;
            } else if (string.equals("add_new_node")) {
                n = 13;
            } else if (string.equals("edit_node_data")) {
                n = 14;
            } else {
                if (string.equals("display_node_popup")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [display_node_popup] is deprecated");
                    return -2;
                }
                if (string.equals("custom_option")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [custom_option] is deprecated");
                    return -2;
                }
                if (string.equals("color_subtree")) {
                    n = 5;
                } else if (string.equals("go_to_swiss_prot")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [go_to_swiss_prot] is deprecated");
                    return -2;
                }
            }
        }
        return n;
    }

    int getClickToOptionsCount() {
        return clickto_options.length;
    }

    String getClickToTitle(int n) {
        return clickto_options[n][0];
    }

    public int getDefaultBootstrapSamples() {
        return this._default_bootstrap_samples;
    }

    int getDefaultDisplayClicktoOption() {
        return this.default_clickto;
    }

    public NodeVisualization.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    public NodeVisualization.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    public short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    SortedMap<String, Color> getDisplayColors() {
        return this._display_colors;
    }

    String getDisplayTitle(int n) {
        return display_options[n][0];
    }

    Map<String, Color> getDomainColors() {
        if (_domain_colors == null) {
            _domain_colors = new Hashtable();
        }
        return _domain_colors;
    }

    public Color getDomainStructureBaseColor() {
        return this._domain_structure_base_color;
    }

    public Color getDomainStructureFontColor() {
        return this._domain_structure_font_color;
    }

    int getGraphicsExportX() {
        return this._graphics_export_x;
    }

    int getGraphicsExportY() {
        return this._graphics_export_y;
    }

    Color getGuiBackgroundColor() {
        return this._gui_background_color;
    }

    Color getGuiButtonBackgroundColor() {
        return this._gui_button_background_color;
    }

    Color getGuiButtonBorderColor() {
        return this._gui_button_border_color;
    }

    Color getGuiButtonTextColor() {
        return this._gui_button_text_color;
    }

    Color getGuiCheckboxAndButtonActiveColor() {
        return this._gui_checkbox_and_button_active_color;
    }

    Color getGuiCheckboxTextColor() {
        return this._gui_checkbox_text_color;
    }

    Color getGuiMenuBackgroundColor() {
        return this._gui_menu_background_color;
    }

    Color getGuiMenuTextColor() {
        return this._gui_menu_text_color;
    }

    double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    Options.NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    short getOvMaxHeight() {
        return this._ov_max_height;
    }

    short getOvMaxWidth() {
        return this._ov_max_width;
    }

    Options.OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    float getPrintLineWidth() {
        return this._print_line_width;
    }

    Hashtable<String, Color> getSpeciesColors() {
        if (_species_colors == null) {
            _species_colors = new Hashtable();
        }
        return _species_colors;
    }

    TreeColorSet getTreeColorSet() {
        return null;
    }

    TreeFontSet getTreeFontSet() {
        return null;
    }

    WebLink getWebLink(String string) {
        return this.getWebLinks().get(string);
    }

    Map<String, WebLink> getWebLinks() {
        return this._weblinks;
    }

    public boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    public boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    public boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    boolean isDrawAsPhylogram() {
        return this.doCheckOption(0);
    }

    boolean isEditable() {
        return this._editable;
    }

    boolean isExtractPfamTaxonomyCodesInNhParsing() {
        return this._nh_parsing_extract_pfam_taxonomy_codes;
    }

    boolean isHasWebLink(String string) {
        return this.getWebLinks().containsKey(string);
    }

    boolean isHideControlPanelAndMenubar() {
        return this._hide_controls_and_menus;
    }

    boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    boolean isShowBranchLengthValues() {
        return this._show_branch_length_values;
    }

    public boolean isShowDefaultNodeShapes() {
        return this._show_default_node_shapes;
    }

    public boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    boolean isShowOverview() {
        return this._show_overview;
    }

    boolean isShowScale() {
        return this._show_scale;
    }

    public boolean isTaxonomyColorizeNodeShapes() {
        return this._taxonomy_colorize_node_shapes;
    }

    final boolean isUseNativeUI() {
        if (this._ui == UI.UNKNOWN && AptxUtil.isMac() && AptxUtil.isJava15()) {
            this._ui = UI.NATIVE;
        }
        return this._ui == UI.NATIVE;
    }

    boolean isUseTabbedDisplay() {
        return this._use_tabbed_display;
    }

    boolean isValidatePhyloXmlAgainstSchema() {
        return this._validate_against_phyloxml_xsd_schema;
    }

    private boolean parseBoolean(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.equals("yes") || string2.equals("true")) {
            return true;
        }
        if (string2.equals("no") || string2.equals("false")) {
            return false;
        }
        ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse boolean value from [" + string + "]");
        return false;
    }

    private double parseDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse double from [" + string + "]");
            d = 0.0;
        }
        return d;
    }

    private float parseFloat(String string) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse float from [" + string + "]");
            f = 0.0f;
        }
        return f;
    }

    private int parseInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse integer from [" + string + "]");
            n = -1;
        }
        return n;
    }

    private short parseShort(String string) {
        int n = -1;
        try {
            n = Short.parseShort(string);
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse short from [" + string + "]");
            n = -1;
        }
        return (short)n;
    }

    private void processFontFamily(StringTokenizer stringTokenizer) {
        String[] stringArray;
        this.setBaseFontFamilyName("");
        String string = ((String)stringTokenizer.nextElement()).trim();
        for (String string2 : stringArray = string.split(",+")) {
            string2 = string2.replace('_', ' ').trim();
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), string2) < 0) continue;
            this.setBaseFontFamilyName(string2);
            break;
        }
    }

    public void putDisplayColors(String string, Color color) {
        this.getDisplayColors().put(string, color);
    }

    private void readConfig(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) == null || (string = string.trim()).startsWith("#") || ForesterUtil.isEmpty(string)) continue;
            string = string.replaceAll("\\s+", "\t");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.setKeyValue(stringTokenizer);
        } while (string != null);
    }

    public void setAbbreviateScientificTaxonNames(boolean bl) {
        this._abbreviate_scientific_names = bl;
    }

    private void setAntialiasScreen(boolean bl) {
        this._antialias_screen = bl;
    }

    public void setBackgroundColorGradient(boolean bl) {
        this._background_color_gradient = bl;
    }

    public void setBaseFontFamilyName(String string) {
        this._base_font_family_name = string;
    }

    public void setBaseFontSize(int n) {
        this._base_font_size = n;
    }

    private void setCladogramType(Options.CLADOGRAM_TYPE cLADOGRAM_TYPE) {
        this._cladogram_type = cLADOGRAM_TYPE;
    }

    public void setColorizeBranches(boolean bl) {
        Configuration.display_options[7][2] = bl ? "yes" : "no";
    }

    public void setColorLabelsSameAsParentBranch(boolean bl) {
        this._color_labels_same_as_parent_branch = bl;
    }

    private void setDefaultBootstrapSamples(int n) {
        this._default_bootstrap_samples = n;
    }

    public void setDefaultNodeFill(NodeVisualization.NodeFill nodeFill) {
        this._default_node_fill = nodeFill;
    }

    public void setDefaultNodeShape(NodeVisualization.NodeShape nodeShape) {
        this._default_node_shape = nodeShape;
    }

    public void setDefaultNodeShapeSize(short s) {
        this._default_node_shape_size = s;
    }

    public void setDisplayAsPhylogram(boolean bl) {
        Configuration.display_options[0][2] = bl ? "yes" : "no";
    }

    public void setDisplayColors(SortedMap<String, Color> sortedMap) {
        this._display_colors = sortedMap;
    }

    public void setDisplayConfidenceValues(boolean bl) {
        Configuration.display_options[4][2] = bl ? "yes" : "no";
    }

    public void setDisplayInternalData(boolean bl) {
        Configuration.display_options[15][2] = bl ? "yes" : "no";
    }

    public void setDisplayNodeNames(boolean bl) {
        Configuration.display_options[1][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceAcc(boolean bl) {
        Configuration.display_options[14][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceNames(boolean bl) {
        Configuration.display_options[13][2] = bl ? "yes" : "no";
    }

    public void setDisplaySequenceRelations(boolean bl) {
        this._display_sequence_relations = bl;
    }

    public void setDisplaySequenceSymbols(boolean bl) {
        Configuration.display_options[20][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyCode(boolean bl) {
        Configuration.display_options[2][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyCommonNames(boolean bl) {
        Configuration.display_options[18][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyImages(boolean bl) {
        Configuration.display_options[24][2] = bl ? "yes" : "no";
    }

    public void setDisplayTaxonomyScientificNames(boolean bl) {
        Configuration.display_options[17][2] = bl ? "yes" : "no";
    }

    public void setDynamicallyHideData(boolean bl) {
        Configuration.display_options[16][2] = bl ? "yes" : "no";
    }

    private void setEditable(boolean bl) {
        this._editable = bl;
    }

    public void setExtractPfamTaxonomyCodesInNhParsing(boolean bl) {
        this._nh_parsing_extract_pfam_taxonomy_codes = bl;
    }

    private void setGraphicsExportX(int n) {
        this._graphics_export_x = n;
    }

    private void setGraphicsExportY(int n) {
        this._graphics_export_y = n;
    }

    private void setInternalNumberAreConfidenceForNhParsing(boolean bl) {
        this._internal_number_are_confidence_for_nh_parsing = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setKeyValue(StringTokenizer stringTokenizer) {
        String string = (String)stringTokenizer.nextElement();
        string = string.replace(':', ' ');
        string = string.trim();
        if ((string = string.toLowerCase()).equals("default_click_to")) {
            String string2 = (String)stringTokenizer.nextElement();
            this.default_clickto = this.getClickToIndex(string2);
            if (this.default_clickto == -1) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "invalid value [" + string2 + "] for [default_click_to]");
                this.default_clickto = 0;
                return;
            }
            if (this.default_clickto != -2) return;
            return;
        }
        if (string.equals("native_ui")) {
            String string3 = ((String)stringTokenizer.nextElement()).trim().toLowerCase();
            if (string3.equals("yes") || string3.equals("true")) {
                this._ui = UI.NATIVE;
                return;
            }
            if (string3.equals("no") || string3.equals("false")) {
                this._ui = UI.CROSSPLATFORM;
                return;
            }
            if (string3.equals("?")) {
                this._ui = UI.UNKNOWN;
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "could not parse yes/no/? value from [" + string3 + "]");
            this._ui = UI.UNKNOWN;
            return;
        }
        if (string.equals("path_to_mafft")) {
            this.setPathToMafft(new File((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("path_to_clustalo")) {
            this.setPathToClustalOmega(new File((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("path_to_fastme")) {
            this.setPathToFastME(new File((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("path_to_mafft")) {
            this.setPathToMafft(new File((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals(VALIDATE_AGAINST_PHYLOXML_XSD_SCHEMA)) {
            this.setValidatePhyloXmlAgainstSchema(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("antialias_screen")) {
            this.setAntialiasScreen(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("phylogeny_graphics_type")) {
            String string4 = ((String)stringTokenizer.nextElement()).trim();
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                return;
            }
            if (string4.equalsIgnoreCase(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR.toString())) {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                return;
            }
            this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string4 + "] for [phylogeny_graphics_type]");
            return;
        }
        if (string.equals("min_confidence_value")) {
            String string5 = ((String)stringTokenizer.nextElement()).trim();
            double d = this.parseDouble(string5);
            this.setMinConfidenceValue(d);
            return;
        }
        if (string.equals("font_family")) {
            this.processFontFamily(stringTokenizer);
            return;
        }
        if (string.equals("font_size")) {
            String string6 = ((String)stringTokenizer.nextElement()).trim();
            int n = this.parseInt(string6);
            this.setBaseFontSize(n);
            return;
        }
        if (string.equals("graphics_export_x")) {
            String string7 = ((String)stringTokenizer.nextElement()).trim();
            int n = this.parseInt(string7);
            this.setGraphicsExportX(n);
            return;
        }
        if (string.equals("graphics_export_y")) {
            String string8 = ((String)stringTokenizer.nextElement()).trim();
            int n = this.parseInt(string8);
            this.setGraphicsExportY(n);
            return;
        }
        if (string.equals("pdf_export_line_width")) {
            String string9 = ((String)stringTokenizer.nextElement()).trim();
            float f = this.parseFloat(string9);
            if (f > 0.0f) {
                this.setPrintLineWidth(f);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "value for [pdf_export_line_width] cannot be zero or negative");
            return;
        }
        if (string.equals("default_number_of_bootstrap_resamples")) {
            String string10 = ((String)stringTokenizer.nextElement()).trim();
            int n = this.parseInt(string10);
            if (n >= 0) {
                this.setDefaultBootstrapSamples(n);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "value for [default_number_of_bootstrap_resamples] cannot be negative");
            return;
        }
        if (string.equals("show_scale")) {
            this.setShowScale(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("show_overview")) {
            this.setShowOverview(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("show_branch_length_values")) {
            this.setShowBranchLengthValues(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("background_gradient")) {
            this.setBackgroundColorGradient(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("color_labels_same_as_branch_length_values")) {
            this.setColorLabelsSameAsParentBranch(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("show_domain_labels")) {
            this.setShowDomainLabels(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("abbreviate_scientific_names")) {
            this.setAbbreviateScientificTaxonNames(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("cladogram_type")) {
            String string11 = ((String)stringTokenizer.nextElement()).trim();
            if (string11.equalsIgnoreCase(Options.CLADOGRAM_TYPE.NON_LINED_UP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
                return;
            }
            if (string11.equalsIgnoreCase(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
                return;
            }
            if (string11.equalsIgnoreCase(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP.toString())) {
                this.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string11 + "] for [cladogram_type]");
            return;
        }
        if (string.equals("non_lined_up_cladogram")) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [non_lined_up_cladogram] is deprecated, use [cladogram_type] instead");
            return;
        }
        if (string.equals("hide_controls_and_menus")) {
            this._hide_controls_and_menus = this.parseBoolean((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("use_tabbed_display")) {
            this._use_tabbed_display = this.parseBoolean((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("overview_width")) {
            short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
            this.setOvMaxWidth(s);
            return;
        }
        if (string.equals("overview_height")) {
            short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
            this.setOvMaxHeight(s);
            return;
        }
        if (string.equals("overview_placement_type")) {
            String string12 = ((String)stringTokenizer.nextElement()).trim();
            if (string12.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                return;
            }
            if (string12.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                return;
            }
            if (string12.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                return;
            }
            if (string12.equalsIgnoreCase(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT.toTag())) {
                this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                return;
            }
            this.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string12 + "] for [overview_placement_type]");
            return;
        }
        if (string.equals("node_label_direction")) {
            String string13 = ((String)stringTokenizer.nextElement()).trim();
            if (string13.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.HORIZONTAL.toString())) {
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                return;
            }
            if (string13.equalsIgnoreCase(Options.NODE_LABEL_DIRECTION.RADIAL.toString())) {
                this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                return;
            }
            this.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string13 + "] for [node_label_direction]");
            return;
        }
        if (string.equals("branch_length_value_digits")) {
            short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
            if (s >= 0) {
                this.setNumberOfDigitsAfterCommaForBranchLengthValue(s);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + s + "] for [branch_length_value_digits]");
            return;
        }
        if (string.equals("confidence_value_digits")) {
            short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
            if (s >= 0) {
                this.setNumberOfDigitsAfterCommaForConfidenceValues(s);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "illegal value [" + s + "] for [confidence_value_digits]");
            return;
        }
        if (string.equals("allow_editing")) {
            this.setEditable(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("display_sequence_relations")) {
            this.setDisplaySequenceRelations(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("replace_underscores_in_nh_parsing")) {
            boolean bl = this.parseBoolean((String)stringTokenizer.nextElement());
            if (bl && this.isExtractPfamTaxonomyCodesInNhParsing()) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                return;
            }
            this.setReplaceUnderscoresInNhParsing(bl);
            return;
        }
        if (string.equals("extract_taxonomy_codes_in_nh_parsing")) {
            boolean bl = this.parseBoolean((String)stringTokenizer.nextElement());
            if (bl && this.isReplaceUnderscoresInNhParsing()) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "attempt to extract taxonomies and replace underscores at the same time");
                return;
            }
            this.setExtractPfamTaxonomyCodesInNhParsing(bl);
            return;
        }
        if (string.equals("internal_labels_are_confidence_values")) {
            this.setInternalNumberAreConfidenceForNhParsing(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (string.equals("gui_background_color")) {
            this._gui_background_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_checkbox_text_color")) {
            this._gui_checkbox_text_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_checkbox_and_button_active_color")) {
            this._gui_checkbox_and_button_active_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_button_text_color")) {
            this._gui_button_text_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_button_background_color")) {
            this._gui_button_background_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_menu_background_color")) {
            this._gui_menu_background_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_menu_text_color")) {
            this._gui_menu_text_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("gui_button_border_color")) {
            this._gui_button_border_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("domain_structure_font_color")) {
            this._domain_structure_font_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("domain_structure_base_color")) {
            this._domain_structure_base_color = Color.decode((String)stringTokenizer.nextElement());
            return;
        }
        if (string.equals("show_default_node_shapes")) {
            this.setShowDefaultNodeShapes(this.parseBoolean(((String)stringTokenizer.nextElement()).trim()));
            return;
        }
        if (string.equals("default_node_size")) {
            short s = this.parseShort(((String)stringTokenizer.nextElement()).trim());
            this.setDefaultNodeShapeSize(s);
            return;
        }
        if (string.equals("default_node_fill")) {
            String string14 = ((String)stringTokenizer.nextElement()).trim();
            if (string14.equalsIgnoreCase(NodeVisualization.NodeFill.NONE.toString())) {
                this.setDefaultNodeFill(NodeVisualization.NodeFill.NONE);
                return;
            }
            if (string14.equalsIgnoreCase(NodeVisualization.NodeFill.GRADIENT.toString())) {
                this.setDefaultNodeFill(NodeVisualization.NodeFill.GRADIENT);
                return;
            }
            if (string14.equalsIgnoreCase(NodeVisualization.NodeFill.SOLID.toString())) {
                this.setDefaultNodeFill(NodeVisualization.NodeFill.SOLID);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string14 + "] for [default_node_fill]");
            return;
        }
        if (string.equals("default_node_shape")) {
            String string15 = ((String)stringTokenizer.nextElement()).trim();
            if (string15.equalsIgnoreCase(NodeVisualization.NodeShape.CIRCLE.toString())) {
                this.setDefaultNodeShape(NodeVisualization.NodeShape.CIRCLE);
                return;
            }
            if (string15.equalsIgnoreCase(NodeVisualization.NodeShape.RECTANGLE.toString())) {
                this.setDefaultNodeShape(NodeVisualization.NodeShape.RECTANGLE);
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "unknown value [" + string15 + "] for [default_node_shape]");
            return;
        }
        if (string.equals("taxonomy_colorize_node_shapes")) {
            this.setTaxonomyColorizeNodeShapes(this.parseBoolean((String)stringTokenizer.nextElement()));
            return;
        }
        if (stringTokenizer.countTokens() >= 2) {
            int n = -1;
            if (string.equals("use_real_br_lengths") || string.equals("phylogram")) {
                n = 0;
                if (string.equals("use_real_br_lengths")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [use_real_br_lengths] is deprecated, use [phylogram] instead");
                }
            } else if (string.equals("rollover")) {
                n = 21;
            } else if (string.equals("color_according_to_species")) {
                n = 6;
            } else if (string.equals("show_node_names")) {
                n = 1;
            } else if (string.equals("show_taxonomy") || string.equals("show_taxonomy_code")) {
                n = 2;
                if (string.equals("show_taxonomy")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [show_taxonomy] is deprecated, use [show_taxonomy_code] instead");
                }
            } else {
                if (string.equals("write_br_length_values")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_br_length_values] is deprecated");
                    return;
                }
                if (string.equals("write_bootstrap_values") || string.equals("write_confidence_values")) {
                    n = 4;
                    if (string.equals("write_bootstrap_values")) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_bootstrap_values] is deprecated, use [write_confidence_values] instead");
                    }
                } else if (string.equals("write_events") || string.equals("write_dup_spec")) {
                    n = 5;
                    if (string.equals("write_dup_spec")) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [write_dup_spec] is deprecated, use [write_events] instead");
                    }
                } else if (string.equals("color_branches")) {
                    n = 7;
                } else if (string.equals("width_branches")) {
                    n = 8;
                } else if (string.equals("color_orthologous")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_orthologous] is deprecated");
                } else if (string.equals("color_subtree_neighbors")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_subtree_neighbors] is deprecated");
                } else if (string.equals("color_super_orthologous")) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [color_super_orthologous] is deprecated");
                } else {
                    if (string.equals("mark_nodes_with_box")) {
                        ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [mark_nodes_with_box] is deprecated");
                        return;
                    }
                    if (string.equals("show_domain_architectures")) {
                        n = 10;
                    } else if (string.equals("show_annotations")) {
                        n = 3;
                    } else if (string.equals("show_binary_characters")) {
                        n = 11;
                    } else if (string.equals("show_binary_character_counts")) {
                        n = 12;
                    } else if (string.equals("show_gene_names")) {
                        n = 13;
                    } else if (string.equals("show_gene_symbols")) {
                        n = 20;
                    } else if (string.equals("show_sequence_acc")) {
                        n = 14;
                    } else {
                        if (string.equals("show_node_ids")) {
                            ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [show_node_ids] is deprecated");
                            return;
                        }
                        if (string.equals("display_internal_data")) {
                            n = 15;
                        } else if (string.equals("dynamically_hide_data")) {
                            n = 16;
                        } else {
                            if (string.equals("show_taxonomy_names")) {
                                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [show_taxonomy_names] is deprecated");
                                return;
                            }
                            if (string.equals("show_taxonomy_scientific_names")) {
                                n = 17;
                            } else if (string.equals("show_taxonomy_common_names")) {
                                n = 18;
                            } else if (string.equals("show_taxonomy_images")) {
                                n = 24;
                            } else if (string.equals("color_according_to_annotation")) {
                                n = 19;
                            } else if (string.equals("show_vector_data")) {
                                n = 23;
                            } else if (string.equals("show_properties")) {
                                n = 25;
                            } else if (string.equals("show_relation_confidence")) {
                                n = 22;
                            } else if (string.equals("show_custom_node_shapes")) {
                                n = 9;
                            }
                        }
                    }
                }
            }
            if (n >= 0) {
                Configuration.display_options[n][1] = (String)stringTokenizer.nextElement();
                Configuration.display_options[n][2] = (String)stringTokenizer.nextElement();
                return;
            }
            if (n == -2) {
                return;
            }
            if (string.equals("click_to")) {
                String string16 = (String)stringTokenizer.nextElement();
                n = this.getClickToIndex(string16);
                if (n >= 0) {
                    Configuration.clickto_options[n][1] = (String)stringTokenizer.nextElement();
                    return;
                }
                if (n == -2) {
                    return;
                }
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown click-to option: " + string16);
                return;
            }
            if (string.equals("species_color")) {
                this.getSpeciesColors().put((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("domain_color")) {
                this.getDomainColors().put((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("annotation_color")) {
                this.getAnnotationColors().put((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                return;
            }
            if (string.equals("function_color")) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "configuration key [function_color] is deprecated");
                return;
            }
            if (string.equals(DISPLAY_COLOR_KEY)) {
                this.putDisplayColors((String)stringTokenizer.nextElement(), Color.decode((String)stringTokenizer.nextElement()));
                return;
            }
            if (!string.equals(WEB_LINK_KEY)) {
                ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + string + "] in: " + this.config_filename);
                return;
            }
            if (stringTokenizer.countTokens() == 3) {
                this.createWebLink((String)stringTokenizer.nextElement(), (String)stringTokenizer.nextElement(), (String)stringTokenizer.nextElement());
                return;
            }
            ForesterUtil.printWarningMessage("Archaeopteryx", "illegal format in configuration file for key [" + string + "]");
            return;
        }
        ForesterUtil.printWarningMessage("Archaeopteryx", "unknown configuration key [" + string + "] in: " + this.config_filename);
    }

    public void setMinConfidenceValue(double d) {
        this._min_confidence_value = d;
    }

    public void setNodeLabelDirection(Options.NODE_LABEL_DIRECTION nODE_LABEL_DIRECTION) {
        this._node_label_direction = nODE_LABEL_DIRECTION;
    }

    public void setNumberOfDigitsAfterCommaForBranchLengthValue(short s) {
        this._number_of_digits_after_comma_for_branch_length_values = s;
    }

    public void setNumberOfDigitsAfterCommaForConfidenceValues(short s) {
        this._number_of_digits_after_comma_for_confidence_values = s;
    }

    private void setOvMaxHeight(short s) {
        this._ov_max_height = s;
    }

    private void setOvMaxWidth(short s) {
        this._ov_max_width = s;
    }

    private void setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE oVERVIEW_PLACEMENT_TYPE) {
        this._ov_placement = oVERVIEW_PLACEMENT_TYPE;
    }

    public void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._phylogeny_graphics_type = pHYLOGENY_GRAPHICS_TYPE;
    }

    public void setPrintLineWidth(float f) {
        this._print_line_width = f;
    }

    public void setReplaceUnderscoresInNhParsing(boolean bl) {
        this._nh_parsing_replace_underscores = bl;
    }

    public void setShowBranchLengthValues(boolean bl) {
        this._show_branch_length_values = bl;
    }

    public void setShowDefaultNodeShapes(boolean bl) {
        this._show_default_node_shapes = bl;
    }

    public void setShowDomainLabels(boolean bl) {
        this._show_domain_labels = bl;
    }

    private void setShowOverview(boolean bl) {
        this._show_overview = bl;
    }

    public void setShowScale(boolean bl) {
        this._show_scale = bl;
    }

    public void setTaxonomyColorize(boolean bl) {
        Configuration.display_options[6][2] = bl ? "yes" : "no";
    }

    public void setTaxonomyColorizeNodeShapes(boolean bl) {
        this._taxonomy_colorize_node_shapes = bl;
    }

    public void setUseBranchesWidths(boolean bl) {
        Configuration.display_options[8][2] = bl ? "yes" : "no";
    }

    private void setValidatePhyloXmlAgainstSchema(boolean bl) {
        this._validate_against_phyloxml_xsd_schema = bl;
    }

    void setWebLinks(SortedMap<String, WebLink> sortedMap) {
        this._weblinks = sortedMap;
    }

    static String getDefaultFontFamilyName() {
        return DEFAULT_FONT_FAMILY;
    }

    public File getPathToMafft() {
        return this._mafft;
    }

    public File getPathToClustalOmega() {
        return this._clustalo;
    }

    public File getPathToFastME() {
        return this._fastme;
    }

    public void setPathToMafft(File file) {
        this._mafft = file;
    }

    public void setPathToClustalOmega(File file) {
        this._clustalo = file;
    }

    public void setPathToFastME(File file) {
        this._fastme = file;
    }

    static {
        DEFAULT_FONT_FAMILY = "";
        for (String string : Constants.DEFAULT_FONT_CHOICES) {
            if (Arrays.binarySearch(AptxUtil.getAvailableFontFamiliesSorted(), string) < 0) continue;
            DEFAULT_FONT_FAMILY = string;
            break;
        }
        if (ForesterUtil.isEmpty(DEFAULT_FONT_FAMILY)) {
            DEFAULT_FONT_FAMILY = Constants.DEFAULT_FONT_CHOICES[Constants.DEFAULT_FONT_CHOICES.length - 1];
        }
    }

    public static enum UI {
        NATIVE,
        CROSSPLATFORM,
        NIMBUS,
        UNKNOWN;

    }

    static enum TRIPLET {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

