/*
 * Decompiled with CFR 0.152.
 */
package JSci.beans;

import JSci.beans.VariableEvent;
import JSci.beans.VariableListener;
import JSci.maths.MathDouble;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.vectors.DoubleVector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public final class VariableBean
implements Serializable {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector variableListeners = new Vector();
    private String variable = new String();
    private Object value;

    public synchronized void setVariable(String string) {
        String string2 = this.variable;
        this.variable = string;
        this.changes.firePropertyChange("variable", string2, string);
    }

    public synchronized String getVariable() {
        return this.variable;
    }

    public synchronized void setValueAsNumber(double d) {
        this.value = new MathDouble(d);
        this.changes.firePropertyChange("valueAsNumber", null, new Double(d));
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public synchronized double getValueAsNumber() {
        if (this.value instanceof MathDouble) {
            return ((MathDouble)this.value).value();
        }
        return Double.NaN;
    }

    public synchronized void setValueAsVector(double[] dArray) {
        this.value = new DoubleVector(dArray);
        this.changes.firePropertyChange("valueAsVector", null, dArray);
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public synchronized void setValueAsMatrix(double[][] dArray) {
        this.value = new DoubleMatrix(dArray);
        this.changes.firePropertyChange("valueAsMatrix", null, dArray);
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVariableListener(VariableListener variableListener) {
        this.variableListeners.addElement(variableListener);
    }

    public synchronized void removeVariableListener(VariableListener variableListener) {
        this.variableListeners.removeElement(variableListener);
    }

    private void fireVariableChanged(VariableEvent variableEvent) {
        for (int i = 0; i < this.variableListeners.size(); ++i) {
            ((VariableListener)this.variableListeners.elementAt(i)).variableChanged(variableEvent);
        }
    }
}

