/*
 * Decompiled with CFR 0.152.
 */
package conifer.apps;

import conifer.apps.AbstractPhyloApp;
import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import conifer.data.TaxonDatum;
import conifer.data.TaxonIndexedData;
import conifer.evol.CalculatorOptions;
import conifer.evol.EvolutionaryFactoryContext;
import conifer.evol.EvolutionaryOptions;
import conifer.evol.EvolutionaryParameters;
import conifer.exp.Experiment;
import conifer.exp.ExperimentOptions;
import conifer.exp.ExperimentalSetup;
import conifer.exp.PrepareExperimentsContext;
import conifer.particle.PhyloDensity;
import conifer.particle.PhyloParticle;
import conifer.particle.PhyloParticleInitContext;
import conifer.particle.TreeProvider;
import conifer.proposals.ProposalModel;
import conifer.proposals.ProposalOptions;
import conifer.trees.TreeModel;
import conifer.trees.TreeOptions;
import fig.basic.Pair;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import monaco.Density;
import monaco.StandardKernel;
import monaco.heat.GenerationIndexedParticle;
import monaco.heat.HeatOptions;
import monaco.heat.HeatingSchedule;
import monaco.mcmc.MCAlgorithm;
import monaco.mcmc.MCAlgorithmOptions;
import monaco.mcmc.MCInitContext;
import monaco.process.Monitor;
import monaco.process.ProcessOptions;
import monaco.process.ProcessSchedule;
import monaco.prop.ProposalProvider;
import nuts.io.IO;
import nuts.io.OutputProducer;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;
import pty.smc.models.LikelihoodModelCalculator;

public class PhyloAppUtils {
    public static void run(String[] args, Object ... objects) {
        AbstractPhyloApp phyloApp = (AbstractPhyloApp)objects[0];
        objects = phyloApp.allOptions.addOptions(objects);
        IO.run(args, objects);
    }

    public static MCAlgorithm<PhyloParticle> getMCAlgorithm(StandardKernel<PhyloParticle> kernel, List<ParticleFilter.ParticleProcessor<PhyloParticle>> processors, ProcessOptions processOptions, Monitor monitor, MCAlgorithmOptions mcOptions) {
        ProcessSchedule schedule = processOptions.getSchedule(monitor);
        MCInitContext initContext = new MCInitContext(processors, mcOptions, schedule);
        return mcOptions.algorithm.getImplementation(kernel, initContext);
    }

    public static List<Pair<Taxon, LikelihoodModelCalculator>> createCalculators(PhylogeneticData data, EvolutionaryOptions evolutionaryOptions, EvolutionaryParameters parameters, CalculatorOptions calculatorOptions) {
        TaxonIndexedData tid = data.getObservedTaxonIndexData();
        Map<Taxon, TaxonDatum> map = tid.getIndexedData(evolutionaryOptions, calculatorOptions);
        ArrayList<Taxon> taxa = CollUtils.list(map.keySet());
        Collections.sort(taxa);
        ArrayList<Pair<Taxon, LikelihoodModelCalculator>> result = CollUtils.list();
        for (Taxon t : taxa) {
            TaxonDatum leafDatum = map.get(t);
            LikelihoodModelCalculator calculator = parameters.createModelCalculator(calculatorOptions, leafDatum);
            result.add(Pair.makePair(t, calculator));
        }
        return result;
    }

    public static File outputDir(File outputDir) {
        return new File(outputDir, "full-data");
    }

    public static Pair<Pair<PhylogeneticData, PhylogeneticData>, List<Experiment>> prepareData(DataOptions dataOptions, ExperimentOptions experimentOptions, File outputDir) {
        PhylogeneticData originalData;
        ArrayList experiments = CollUtils.list();
        PhylogeneticData heldoutData = originalData = dataOptions.dataModel.loadDataset(dataOptions);
        heldoutData.writeToDisk(PhyloAppUtils.outputDir(outputDir));
        ArrayList<ExperimentalSetup> setups = experimentOptions.experiments;
        PrepareExperimentsContext context = new PrepareExperimentsContext(System.currentTimeMillis());
        boolean changed = false;
        for (ExperimentalSetup setup : setups) {
            Experiment experiment = setup.prepareExperiment(heldoutData, experimentOptions, context);
            if (experiment instanceof OutputProducer) {
                File subDir = new File(outputDir, experiment.name());
                subDir.mkdir();
                ((OutputProducer)((Object)experiment)).setOutputFolder(subDir);
            }
            experiments.add(experiment);
            PhylogeneticData updated = experiment.getDataAfterHoldingOut();
            if (updated == null) continue;
            changed = true;
            heldoutData = updated;
        }
        if (changed) {
            heldoutData.writeToDisk(new File(outputDir, "post-heldout-data"));
        }
        return Pair.makePair(Pair.makePair(originalData, heldoutData), experiments);
    }

    public static boolean isConsistent(Collection<ProposalModel> proposalModels, TreeModel treeModel) {
        for (ProposalModel model : proposalModels) {
            if (model.isClock() == null || model.isClock().booleanValue() == treeModel.isClock()) continue;
            return false;
        }
        return true;
    }

    public static StandardKernel<PhyloParticle> getKernel(HeatOptions heatOptions, PhylogeneticData dataBeforeHeldout, PhylogeneticData dataAfterHeldout, EvolutionaryOptions inferenceEvolutionaryOptions, CalculatorOptions calculatorOptions, TreeOptions inferenceTreeOptions, ProposalOptions proposalOptions, File outputDir) {
        TreeProvider treeProvider;
        HeatingSchedule<GenerationIndexedParticle> schedule = heatOptions.heatModel.getHeatingSchedule(heatOptions);
        EvolutionaryFactoryContext context = new EvolutionaryFactoryContext();
        try {
            context.actualNumberOfSites = dataAfterHeldout.getMsa().columns().size();
        }
        catch (Exception e) {
            // empty catch block
        }
        EvolutionaryParameters parameters = inferenceEvolutionaryOptions.model.instantiateParameters(inferenceEvolutionaryOptions, context);
        List<Pair<Taxon, LikelihoodModelCalculator>> calculators = PhyloAppUtils.createCalculators(dataAfterHeldout, inferenceEvolutionaryOptions, parameters, calculatorOptions);
        Density<PhyloParticle> prior = inferenceTreeOptions.model.getPriorDensity(inferenceTreeOptions);
        proposalOptions.initTreeOptions.nTaxa = dataAfterHeldout.getObservedTaxonIndexData().nTaxa();
        PhyloParticleInitContext.MSAProvider msaProvider = proposalOptions.getMSAProvider(dataBeforeHeldout, dataAfterHeldout);
        if (msaProvider instanceof OutputProducer) {
            File subDir = new File(outputDir, "init-msa");
            subDir.mkdir();
            ((OutputProducer)((Object)msaProvider)).setOutputFolder(subDir);
        }
        if ((treeProvider = proposalOptions.getTreeProvider(dataBeforeHeldout, dataAfterHeldout, msaProvider.getMSA())) instanceof OutputProducer) {
            File subDir = new File(outputDir, "init-tree");
            subDir.mkdir();
            ((OutputProducer)((Object)treeProvider)).setOutputFolder(subDir);
        }
        PhyloParticleInitContext particleInitContext = new PhyloParticleInitContext(dataAfterHeldout.getObservedTaxonIndexData(), treeProvider, msaProvider, parameters, proposalOptions);
        PhyloParticle initialParticle = proposalOptions.getInitialParticle();
        initialParticle.init(calculators, prior, particleInitContext);
        if (!proposalOptions.skipConsistencyCheck && !PhyloAppUtils.isConsistent(proposalOptions.proposalModels, inferenceTreeOptions.model)) {
            throw new RuntimeException("Prior and proposal should both be over clock or over nonclock trees");
        }
        ProposalProvider<PhyloParticle> provider = proposalOptions.getProposalCombination();
        int nIters = proposalOptions.getNIterations(initialParticle);
        return new StandardKernel<GenerationIndexedParticle>(initialParticle, provider, PhyloDensity.instance, nIters, schedule);
    }
}

