/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.tests;

import conifer.ml.CTMCExpFam;
import conifer.ml.ExpectedStatistics;
import conifer.ml.data.EndPointDataset;
import conifer.ml.extractors.IdentityExtractor;
import fig.basic.LogInfo;
import fig.basic.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import ma.RateMatrixLoader;
import nuts.tui.Table;
import nuts.util.Indexer;

public class TestExpectedStatistics {
    public static void main(String[] args) {
        Random rand = new Random(1L);
        Indexer<Character> indexer = RateMatrixLoader.rnaIndexer();
        CTMCExpFam frrm = null;
        Set c1 = Collections.singleton(new IdentityExtractor());
        frrm.extractUnivariateFeatures(c1);
        frrm.extractReversibleBivariateFeatures(c1);
        double[] trueW = new double[frrm.nFeatures()];
        for (int i = 0; i < trueW.length; ++i) {
            trueW[i] = rand.nextDouble() / 4.0;
        }
        double[][] trueRateMtx = frrm.reversibleModelWithParameters(trueW).getRateMatrix();
        LogInfo.logsForce("trueMtx = \n" + Table.toString(trueRateMtx));
        double bl = 1.5;
        int nSeries = 1000000;
        EndPointDataset<Character> data = new EndPointDataset<Character>();
        ExpectedStatistics stat = new ExpectedStatistics(frrm);
        LogInfo.track("Generating data");
        for (int i = 0; i < nSeries; ++i) {
            List<Pair<Integer, Double>> fullPath = data.addGeneratedData(bl, trueRateMtx, rand, indexer);
            stat.addInitialAndFullyObservedPathStatistics(fullPath);
        }
        LogInfo.end_track();
        System.out.println(stat);
        ExpectedStatistics<Character> stat2 = new ExpectedStatistics<Character>(frrm);
        stat2.addFromMarginalizedData(data, trueRateMtx);
        System.out.println(stat2);
    }
}

