/*
 * Decompiled with CFR 0.152.
 */
package conifer.pip;

import conifer.pip.LinearizedAlignment;
import conifer.pip.PIPLikelihoodUtils;
import ev.poi.PoissonParameters;
import fig.basic.IOUtils;
import fig.basic.Option;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.math.RateMtxUtils;
import nuts.maxent.SloppyMath;
import nuts.util.MathUtils;
import pty.RootedTree;
import pty.io.Dataset;

public class PIPLikelihoodCalculator {
    private PoissonParameters pip;
    private LinearizedAlignment linearizedMSA;
    private RootedTree tree;
    private List<Taxon> postOrderTaxaTraversal;
    private int nMSAColumns;
    private final double logMu;
    private final double mu;
    private final double nu;
    private final double logNu;
    private final double totalTreeLength;
    private final int nCharacters;
    private final double[] logPi;
    private final int fullGapIndex;
    private final int nSitesPlusFullGap;
    private final Set<Taxon> leaves;
    private final Map<Taxon, Taxon> lefts;
    private final Map<Taxon, Taxon> rights;
    private Map<Taxon, Double> logSurvivalPrs;
    private Map<Taxon, boolean[]> commonAncestorIndicators;
    private Map<Taxon, double[][]> logPeelingDetails;
    private Map<Taxon, double[]> logPeelingSummaries;
    private Map<Taxon, Double> logInsertLocationPrs;
    private Map<Taxon, int[]> descCounts;
    private int[] nonGapCounts;

    public PIPLikelihoodCalculator(PoissonParameters pip, LinearizedAlignment linearizedMSA, RootedTree tree) {
        this.pip = pip;
        this.linearizedMSA = linearizedMSA;
        this.tree = tree;
        this.postOrderTaxaTraversal = new ArrayList<Taxon>();
        PIPLikelihoodUtils.fillPostOrder(this.postOrderTaxaTraversal, tree.topology());
        this.nMSAColumns = linearizedMSA.nColumns();
        this.mu = pip.deleteRate;
        this.logMu = Math.log(this.mu);
        this.totalTreeLength = PIPLikelihoodUtils.totalTreeLength(tree.branchLengths());
        this.nu = pip.insertRate * (this.totalTreeLength + 1.0 / this.mu);
        this.logNu = Math.log(this.nu);
        this.nSitesPlusFullGap = this.nMSAColumns + 1;
        this.fullGapIndex = this.nSitesPlusFullGap - 1;
        this.nCharacters = pip.numberOfCharacter;
        this.logPi = pip.quasiStatLogProbabilities;
        assert (this.logPi.length == this.nCharacters);
        this.leaves = new HashSet<Taxon>(tree.topology().leaveContents());
        this.lefts = PIPLikelihoodUtils.extractChild(0, tree.topology());
        this.rights = PIPLikelihoodUtils.extractChild(1, tree.topology());
    }

    public double computeDataLogProbabilityGivenTree() {
        this.computePeelingRecursions();
        this.prepareLogSurvivalPrs();
        this.prepareCommonAncestorIndicators();
        this.prepareLogInsertLocationPrs();
        double[] logZs = this.computeLogZ_phase1();
        System.out.println(Arrays.toString(logZs));
        return this.computeLogZ_phase2_nonGap(logZs) + this.logPhi(this.computeZ_phase2_gap(logZs));
    }

    private void prepareCommonAncestorIndicator(Taxon t) {
        int s;
        int[] newDescCount = new int[this.nMSAColumns];
        this.descCounts.put(t, newDescCount);
        if (this.isLeaf(t)) {
            double[][] felArray = this.logPeelingDetails.get(t);
            for (s = 0; s < this.nMSAColumns; ++s) {
                newDescCount[s] = this.isGap(felArray, s) ? 0 : 1;
            }
        } else {
            int[] leftDescCount = this.descCounts.get(this.left(t));
            int[] rightDescCount = this.descCounts.get(this.right(t));
            for (int s2 = 0; s2 < this.nMSAColumns; ++s2) {
                newDescCount[s2] = leftDescCount[s2] + rightDescCount[s2];
            }
        }
        boolean[] commonAncestorIndicator = new boolean[this.nMSAColumns];
        this.commonAncestorIndicators.put(t, commonAncestorIndicator);
        for (s = 0; s < this.nMSAColumns; ++s) {
            commonAncestorIndicator[s] = this.nonGapCounts[s] == newDescCount[s];
        }
    }

    private double logPhi(double z) {
        return (z - 1.0) * this.nu + (double)this.nMSAColumns * this.logNu - MathUtils.logFactorial(this.nMSAColumns);
    }

    private void computePeelingRecursions() {
        this.logPeelingDetails = new HashMap<Taxon, double[][]>();
        this.logPeelingSummaries = new HashMap<Taxon, double[]>();
        this.nonGapCounts = new int[this.nSitesPlusFullGap];
        for (Taxon t : this.postOrderTaxaTraversal) {
            double[][] currentFelsensteinArray = this.isLeaf(t) ? this.initFelsensteinArray(t) : PIPLikelihoodUtils.standardLogScaleFelsensteinRecursion(this.logPeelingDetails.get(this.left(t)), this.logPeelingDetails.get(this.right(t)), this.marginalLogPr(this.left(t)), this.marginalLogPr(this.right(t)));
            this.logPeelingDetails.put(t, currentFelsensteinArray);
            this.logPeelingSummaries.put(t, this.logPeelingSummary(currentFelsensteinArray));
        }
    }

    private double[] logPeelingSummary(double[][] currentFelsensteinArray) {
        double[] result = new double[currentFelsensteinArray.length];
        for (int s = 0; s < this.nSitesPlusFullGap; ++s) {
            double siteLogLikelihood = Double.NEGATIVE_INFINITY;
            double[] curCache = currentFelsensteinArray[s];
            for (int x = 0; x < this.nCharacters; ++x) {
                siteLogLikelihood = SloppyMath.logAdd(siteLogLikelihood, curCache[x] + this.logPi[x]);
            }
            if (!PIPLikelihoodCalculator.isSiteLogLikelihoodValid(siteLogLikelihood)) {
                throw new RuntimeException("Missing data not currently supported");
            }
            result[s] = siteLogLikelihood;
        }
        return result;
    }

    private double[] computeLogZ_phase1() {
        double[] workArray = new double[this.nSitesPlusFullGap];
        for (int s = 0; s < this.nSitesPlusFullGap; ++s) {
            workArray[s] = Double.NEGATIVE_INFINITY;
        }
        for (Taxon t : this.postOrderTaxaTraversal) {
            this.computeLogZ_phase1(workArray, t);
        }
        return workArray;
    }

    private double computeLogZ_phase2_nonGap(double[] array) {
        double logProduct = 0.0;
        for (int s = 0; s < this.nMSAColumns; ++s) {
            logProduct += array[s];
        }
        return logProduct;
    }

    private double computeZ_phase2_gap(double[] array) {
        return Math.exp(array[this.fullGapIndex]);
    }

    private void computeLogZ_phase1(double[] workArray, Taxon t) {
        boolean[] commonAncestorIndicator = this.commonAncestorIndicators.get(t);
        double logInsertPr = this.logInsertLocationPrs.get(t);
        double[] logPeelingSummary = this.logPeelingSummaries.get(t);
        double logSurvivalPr = this.logSurvivalPrs.get(t);
        for (int s = 0; s < this.nMSAColumns; ++s) {
            workArray[s] = SloppyMath.logAdd(commonAncestorIndicator[s] ? logInsertPr + logPeelingSummary[s] + logSurvivalPr : Double.NEGATIVE_INFINITY, workArray[s]);
        }
        double logColumnConditionalPr = Math.log(1.0 + Math.exp(logSurvivalPr) * (Math.exp(logPeelingSummary[this.fullGapIndex]) - 1.0));
        workArray[this.fullGapIndex] = SloppyMath.logAdd(logInsertPr + logColumnConditionalPr, workArray[this.fullGapIndex]);
    }

    private void prepareLogInsertLocationPrs() {
        this.logInsertLocationPrs = new HashMap<Taxon, Double>();
        double prefix = -Math.log(this.totalTreeLength + 1.0 / this.mu);
        for (Taxon t : this.postOrderTaxaTraversal) {
            this.logInsertLocationPrs.put(t, prefix + (this.isRoot(t) ? -this.logMu : Math.log(this.branchLength(t))));
        }
    }

    private void prepareLogSurvivalPrs() {
        this.logSurvivalPrs = new HashMap<Taxon, Double>();
        for (Taxon t : this.postOrderTaxaTraversal) {
            double bl = this.isRoot(t) ? Double.NaN : this.branchLength(t);
            this.logSurvivalPrs.put(t, this.isRoot(t) ? 0.0 : Math.log(1.0 - Math.exp(-this.mu * bl)) - this.logMu - Math.log(bl));
        }
    }

    private void prepareCommonAncestorIndicators() {
        this.descCounts = new HashMap<Taxon, int[]>();
        this.commonAncestorIndicators = new HashMap<Taxon, boolean[]>();
        for (Taxon t : this.postOrderTaxaTraversal) {
            this.prepareCommonAncestorIndicator(t);
        }
    }

    private double[][] marginalLogPr(Taxon t) {
        double[][] Q = this.pip.Q;
        double[][] prs = RateMtxUtils.marginalTransitionMtx(Q, this.branchLength(t));
        return Dataset.DatasetUtils.log(prs);
    }

    private boolean isGap(double[][] felArray, int s) {
        return felArray[s][this.pip.gapIndex] == 0.0;
    }

    private boolean isRoot(Taxon t) {
        return this.tree.topology().getContents().equals(t);
    }

    private double branchLength(Taxon t) {
        return this.tree.branchLengths().get(t);
    }

    private Taxon right(Taxon t) {
        return this.lefts.get(t);
    }

    private Taxon left(Taxon t) {
        return this.rights.get(t);
    }

    private boolean isLeaf(Taxon t) {
        return this.leaves.contains(t);
    }

    private double[][] initFelsensteinArray(Taxon t) {
        double[][] indicators = this.linearizedMSA.indicators(t, this.pip.indexer, this.pip.gapIndex);
        double[][] result = new double[this.nSitesPlusFullGap][this.nCharacters + 1];
        for (int s = 0; s < this.nMSAColumns; ++s) {
            for (int x = 0; x < this.nCharacters + 1; ++x) {
                double value = indicators[s][x];
                if (value == 1.0 && x < this.nCharacters) {
                    int n = s;
                    this.nonGapCounts[n] = this.nonGapCounts[n] + 1;
                }
                if (value != 0.0 && value != 1.0) {
                    throw new RuntimeException();
                }
                result[s][x] = Math.log(value);
            }
        }
        for (int x = 0; x < this.nCharacters + 1; ++x) {
            result[this.fullGapIndex][x] = Math.log(x == this.pip.gapIndex ? 1.0 : 0.0);
        }
        return result;
    }

    private static boolean isSiteLogLikelihoodValid(double number) {
        return number <= 1.0E-6;
    }

    public void printPseudoCode(File dir) {
        double pr = this.computeDataLogProbabilityGivenTree();
        PrintWriter out = IOUtils.openOutHard(new File(dir, "pseudocode.tex"));
        out.println("\\begin{enumerate}");
        out.println("\\item Inputs:");
        out.println("\\begin{enumerate}");
        out.println("\\item PIP parameter values $(\\lambda, \\mu)$, substitution matrix $\\theta$ over $\\Sigma$. \\\\ \\emph{Example: $(\\lambda, \\mu) = (" + this.pip.insertRate + "," + this.pip.deleteRate + "), \\Sigma = \\{\\textrm{a}\\}$}");
        out.println("\\item Rooted phylogenetic tree $\\tau$ \\\\ \\emph{Example: $\\tau = " + RootedTree.Util.toNewick(this.tree).replaceAll("v", "v_").replaceAll("internal", "v_") + "$}");
        out.println("\\item Multiple sequence alignment $m$ \\\\ \\emph{Example:} $m = $\\begin{verbatim}\n" + this.linearizedMSA.getMsa().toString().replaceAll("v", "v_").replaceAll("(?m)^[ \t]*\r?\n", "") + "\\end{verbatim}");
        out.println("\\end{enumerate}");
        out.println("\\item Computing modified Felsenstein recursion:");
        out.println("\\begin{enumerate}");
        out.println("\\item For each site, compute $\\tilde f_v(\\sigma)$ in post-order using Equation~(\\ref{eq:tfvs}), and from each $\\tilde f_v(\\sigma)$, compute $\\tilde f_v$ using Equation~(\\ref{eq:tfv}) \\\\ \\emph{Example: " + this.printTildeFs(false) + "}");
        out.println("\\item Do the same for an artificial site or column $c_{\\emptyset}$ where all leaves have a gap \\\\ \\emph{Example: " + this.printTildeFs(true) + "}");
        out.println("\\end{enumerate}");
        out.println("\\item For each node $v$ in the tree, compute the survival probability $\\beta(v)$ using Equation~(\\ref{eq:betas}) (setting it to 1 at the root for convenience) \\\\ \\emph{Example: \\\\ " + this.printBetas() + "}");
        out.println("\\item For each site, compute the set of nodes $A$ ancestral to all extant characters, as described in the caption of Figure~\\ref{fig:pscp-fel} \\\\\\emph{Example: " + this.printAs() + "}");
        out.println("\\item Computing $f_v$:");
        out.println("\\begin{enumerate}");
        out.println("\\item For each site, compute $f_v$ using Equation~(\\ref{eq:fv}) \\\\\\emph{Example: " + this.printFs(false) + "}");
        out.println("\\item For $c_{\\emptyset}$, use Equation~(\\ref{eq:fvgap}) \\\\ \\emph{Example: " + this.printFs(true) + "}");
        out.println("\\end{enumerate}");
        out.println("\\item For each node $v$ in the tree, compute $\\iota_v = \\P(V = v)$ as shown in Section~3 of the main paper \\\\ \\emph{Example: \\\\ " + this.printInserts() + "}");
        out.println("\\item Compute $p_\\tau(m)$ from the $\\iota_v$'s, $f_v$'s as shown in Section~3 of the main paper \\\\ \\emph{Example: $\\log p_\\tau(m) = " + PIPLikelihoodCalculator.fmt(pr) + "$}");
        out.println("\\end{enumerate}");
        out.close();
    }

    private String printAs() {
        String result = "";
        for (int s = 0; s < this.nSitesPlusFullGap - 1; ++s) {
            result = result + "\\\\for site " + (s + 1) + ", $A = \\{";
            for (Taxon t : this.postOrderTaxaTraversal) {
                if (!this.commonAncestorIndicators.get(t)[s]) continue;
                result = result + t.toString().replaceAll("v", "v_").replaceAll("internal", "v_") + ",";
            }
            result = result.substring(0, result.length() - 1);
            result = result + "\\}$";
        }
        return result;
    }

    public static String fmt(double n) {
        return String.format(Locale.US, "%.2g", n);
    }

    private String printBetas() {
        String part1 = "";
        String part2 = "";
        for (Taxon t : this.postOrderTaxaTraversal) {
            part1 = part1 + "\\beta(" + t.toString().replaceAll("v", "v_").replaceAll("internal", "v_") + "),";
            part2 = part2 + "" + PIPLikelihoodCalculator.fmt(Math.exp(this.logSurvivalPrs.get(t))) + ",";
        }
        part1 = part1.substring(0, part1.length() - 1);
        part2 = part2.substring(0, part2.length() - 1);
        return "$(" + part1 + ") = (" + part2 + ")$";
    }

    private String printInserts() {
        String part1 = "";
        String part2 = "";
        for (Taxon t : this.postOrderTaxaTraversal) {
            part1 = part1 + "\\iota(" + t.toString().replaceAll("v", "v_").replaceAll("internal", "v_") + "),";
            part2 = part2 + "" + PIPLikelihoodCalculator.fmt(Math.exp(this.logInsertLocationPrs.get(t))) + ",";
        }
        part1 = part1.substring(0, part1.length() - 1);
        part2 = part2.substring(0, part2.length() - 1);
        return "$(" + part1 + ") = (" + part2 + ")$";
    }

    private String printFs(boolean gap) {
        String result = "";
        for (int s = gap ? this.fullGapIndex : 0; s < (gap ? this.nSitesPlusFullGap : this.nSitesPlusFullGap - 1); ++s) {
            result = result + "\\\\for site " + (s + 1) + ", ";
            String part1 = "";
            String part2 = "";
            for (Taxon t : this.postOrderTaxaTraversal) {
                part1 = part1 + "f_{" + t.toString().replaceAll("v", "v_").replaceAll("internal", "v_") + "},";
                if (gap) {
                    part2 = part2 + "" + PIPLikelihoodCalculator.fmt(1.0 + Math.exp(this.logSurvivalPrs.get(t)) * (Math.exp(this.logPeelingSummaries.get(t)[this.fullGapIndex]) - 1.0)) + ",";
                    continue;
                }
                part2 = part2 + "" + PIPLikelihoodCalculator.fmt(Math.exp(this.commonAncestorIndicators.get(t)[s] ? this.logPeelingSummaries.get(t)[s] + this.logSurvivalPrs.get(t) : Double.NEGATIVE_INFINITY)) + ",";
            }
            part1 = part1.substring(0, part1.length() - 1);
            part2 = part2.substring(0, part2.length() - 1);
            result = result + "$(" + part1 + ") = (" + part2 + ")$; ";
        }
        return result;
    }

    private String printTildeFs(boolean gap) {
        String result = "";
        for (int s = gap ? this.fullGapIndex : 0; s < (gap ? this.nSitesPlusFullGap : this.nSitesPlusFullGap - 1); ++s) {
            result = result + "\\\\for site " + (s + 1) + ", ";
            String part1 = "";
            String part2 = "";
            for (Taxon t : this.postOrderTaxaTraversal) {
                part1 = part1 + "\\tilde f_{" + t.toString().replaceAll("v", "v_").replaceAll("internal", "v_") + "},";
                part2 = part2 + "" + PIPLikelihoodCalculator.fmt(Math.exp(this.logPeelingSummaries.get(t)[s])) + ",";
            }
            part1 = part1.substring(0, part1.length() - 1);
            part2 = part2.substring(0, part2.length() - 1);
            result = result + "$(" + part1 + ") = (" + part2 + ")$; ";
        }
        return result;
    }

    public static void main(String[] args) {
        IO.run(args, new PseudoCodeCreator());
    }

    public static class PseudoCodeCreator
    implements Runnable {
        @Option(required=true)
        public File alignmentFile;
        @Option(required=true)
        public File treeFile;
        @Option
        public double mu = 1.0;
        @Option
        public double lambda = 2.0;

        @Override
        public void run() {
            PoissonParameters.star = (char)97;
            PoissonParameters pp = PoissonParameters.rnaParams(this.lambda, this.mu);
            RootedTree rt = RootedTree.Util.load(this.treeFile);
            System.out.println("Tree:\n" + rt.toString());
            MSAPoset msa = MSAPoset.parseFASTA(this.alignmentFile);
            System.out.println("Align:\n" + msa);
            LinearizedAlignment la = new LinearizedAlignment(msa);
            PIPLikelihoodCalculator calc = new PIPLikelihoodCalculator(pp, la, rt);
            System.out.println("Exact");
            calc.computeDataLogProbabilityGivenTree();
            for (double epsilon = 1.0; epsilon > 1.0E-6; epsilon /= 10.0) {
                System.out.println("Approx(" + epsilon + ")");
                PIPLikelihoodCalculator pIPLikelihoodCalculator = calc;
                pIPLikelihoodCalculator.getClass();
                ApproximateCalculator ac = pIPLikelihoodCalculator.new ApproximateCalculator(epsilon);
            }
        }
    }

    public class ApproximateCalculator {
        private final Taxon root;
        private final double epsilon;
        private final int nSites;
        private Map<Taxon, double[][]> logPeelingDetails;
        private Map<Taxon, double[]> logPeelingSummaries;
        private final double[][] Q;

        private ApproximateCalculator(double epsilon) {
            this.nSites = PIPLikelihoodCalculator.this.nSitesPlusFullGap - 1;
            this.root = PIPLikelihoodCalculator.this.tree.getRooted().topology().getContents();
            this.epsilon = epsilon;
            this.Q = this.getApproxRateMatrix();
            this.computePeelingRecursions();
            System.out.println(Arrays.toString(this.computeColumnPrs()));
        }

        private double[] computeColumnPrs() {
            double[][] rootLogMessage = this.logPeelingDetails.get(this.root);
            double[] columnLogPrs = new double[this.nSites];
            double[] logStatio = ((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).pip.quasiStatLogProbabilities;
            double logC = Math.log(PIPLikelihoodCalculator.this.totalTreeLength + 1.0 / PIPLikelihoodCalculator.this.mu);
            for (int site = 0; site < this.nSites; ++site) {
                double logSum = rootLogMessage[site][0] - Math.log(this.epsilon) - logC;
                for (int charIndex = 0; charIndex < PIPLikelihoodCalculator.this.nCharacters; ++charIndex) {
                    double currentLog = logStatio[charIndex] + rootLogMessage[site][charIndex + 1] - PIPLikelihoodCalculator.this.logMu - logC;
                    logSum = SloppyMath.logAdd(currentLog, logSum);
                }
                columnLogPrs[site] = logSum;
            }
            return columnLogPrs;
        }

        private double[][] marginalLogPr(Taxon t) {
            double[][] prs = RateMtxUtils.marginalTransitionMtx(this.Q, PIPLikelihoodCalculator.this.branchLength(t));
            return Dataset.DatasetUtils.log(prs);
        }

        private void computePeelingRecursions() {
            this.logPeelingDetails = new HashMap<Taxon, double[][]>();
            for (Taxon t : PIPLikelihoodCalculator.this.postOrderTaxaTraversal) {
                double[][] currentFelsensteinArray = PIPLikelihoodCalculator.this.isLeaf(t) ? this.initFelsensteinArray(t) : PIPLikelihoodUtils.standardLogScaleFelsensteinRecursion(this.logPeelingDetails.get(PIPLikelihoodCalculator.this.left(t)), this.logPeelingDetails.get(PIPLikelihoodCalculator.this.right(t)), this.marginalLogPr(PIPLikelihoodCalculator.this.left(t)), this.marginalLogPr(PIPLikelihoodCalculator.this.right(t)));
                this.logPeelingDetails.put(t, currentFelsensteinArray);
            }
        }

        private double[][] initFelsensteinArray(Taxon t) {
            double[][] indicators = PIPLikelihoodCalculator.this.linearizedMSA.indicators(t, ((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).pip.indexer, ((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).pip.gapIndex);
            double[][] result = new double[PIPLikelihoodCalculator.this.nSitesPlusFullGap][PIPLikelihoodCalculator.this.nCharacters + 2];
            for (int s = 0; s < PIPLikelihoodCalculator.this.nMSAColumns; ++s) {
                for (int pipIndex = 0; pipIndex < PIPLikelihoodCalculator.this.nCharacters + 1; ++pipIndex) {
                    double value = indicators[s][pipIndex];
                    if (value != 0.0 && value != 1.0) {
                        throw new RuntimeException();
                    }
                    result[s][pipIndex + 1] = Math.log(value);
                }
                result[s][0] = indicators[s][PIPLikelihoodCalculator.this.nCharacters] == 1.0 ? 0.0 : Double.NEGATIVE_INFINITY;
            }
            for (int approxIndex = 0; approxIndex < PIPLikelihoodCalculator.this.nCharacters + 2; ++approxIndex) {
                result[((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).fullGapIndex][approxIndex] = Math.log(approxIndex == PIPLikelihoodCalculator.this.nCharacters + 1 || (double)approxIndex == 0.0 ? 1.0 : 0.0);
            }
            return result;
        }

        private double[][] getApproxRateMatrix() {
            int expIndex;
            int nExpCharset = PIPLikelihoodCalculator.this.nCharacters + 2;
            double[][] result = new double[nExpCharset][nExpCharset];
            for (expIndex = 1; expIndex < nExpCharset - 1; ++expIndex) {
                int charIndex = expIndex - 1;
                double statio = ((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).pip.quasiStatProbs[charIndex];
                result[0][expIndex] = statio * this.epsilon;
            }
            for (expIndex = 1; expIndex < nExpCharset - 1; ++expIndex) {
                result[expIndex][nExpCharset - 1] = PIPLikelihoodCalculator.this.mu;
            }
            for (expIndex = 1; expIndex < nExpCharset - 1; ++expIndex) {
                int charIndex1 = expIndex - 1;
                for (int expIndex2 = 1; expIndex2 < nExpCharset - 1; ++expIndex2) {
                    int charIndex2 = expIndex2 - 1;
                    if (charIndex1 == charIndex2) continue;
                    result[expIndex][expIndex2] = ((PIPLikelihoodCalculator)PIPLikelihoodCalculator.this).pip.subRateMtx[charIndex1][charIndex2];
                }
            }
            RateMtxUtils.fillRateMatrixDiagonalEntries(result);
            return result;
        }
    }
}

