/*
 * Decompiled with CFR 0.152.
 */
package conifer.rna;

import conifer.rna.RNAMove;
import java.util.HashMap;
import java.util.Set;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;

public class RNAmexp {
    boolean useRNAeval;
    boolean readSubset;
    String subsetFile;
    HashMap<RNAMove.Neighbor, Integer> map = new HashMap();
    int counter = 0;
    double[][] matrix;
    int size;

    RNAmexp(boolean useRNAeval) {
        this.useRNAeval = useRNAeval;
    }

    RNAmexp(boolean useRNAeval, boolean readSubset, String subsetFile) {
        this.useRNAeval = useRNAeval;
        this.readSubset = readSubset;
        this.subsetFile = subsetFile;
    }

    public void makeMatrix(RNAMove.Neighbor point, double t) {
        this.counter = 0;
        if (this.readSubset) {
            RNAMove.makeStateSpace(point.neighbor, this.subsetFile);
        }
        this.dfs(point);
        this.size = this.map.size();
        this.matrix = new double[this.size][this.size];
        Set<RNAMove.Neighbor> keys = this.map.keySet();
        for (RNAMove.Neighbor p : keys) {
            RNAMove m = new RNAMove(p.sequence, null);
            m.structure = p.neighbor;
            m.enumerateNeighbors(p.sequence);
            if (this.useRNAeval) {
                m.getEnergies();
            }
            int i = this.map.get(p);
            double sum = 0.0;
            for (RNAMove.Neighbor n : m.neighbors) {
                int j = this.map.get(n);
                this.matrix[i][j] = n.rate * t;
                sum += n.rate * t;
            }
            this.matrix[i][i] = -sum;
        }
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                s = s + this.matrix[i][j] + " ";
            }
            s = s + "\n";
        }
        return s;
    }

    public double[][] matrix() {
        return this.matrix;
    }

    public DoubleMatrix expm() {
        DoubleMatrix dm = new DoubleMatrix(this.matrix);
        return MatrixFunctions.expm((DoubleMatrix)dm);
    }

    public void dfs(RNAMove.Neighbor point) {
        RNAMove m = new RNAMove(point.sequence, null);
        m.structure = point.neighbor;
        m.enumerateNeighbors(point.sequence);
        if (this.useRNAeval) {
            m.getEnergies();
        }
        for (RNAMove.Neighbor n : m.neighbors) {
            if (n.neighbor == point.neighbor || this.map.containsKey(n)) continue;
            this.map.put(n, this.counter);
            ++this.counter;
            double ex = n.rate;
            this.dfs(n);
        }
    }
}

