/*
 * Decompiled with CFR 0.152.
 */
package emc;

import comm.Message;
import emc.EMCNode;
import fig.basic.Parallelizer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import monaco.process.ProcessSchedule;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class SimulateEMC<S> {
    private List<EMCNode<S>> nodes = CollUtils.list();
    private Message[] weightMsgs;
    private double[] sums;
    private AtomicInteger numMsgs;
    private int M;
    private int K;
    public static Allocation scheme;

    public SimulateEMC(int K, int M, int Km, int seed1, int seed2, ParticleKernel<S> kernel, ParticleFilter.ParticleProcessor<S> processor, ProcessSchedule schedule) {
        this.weightMsgs = new Message[M];
        this.K = K;
        this.M = M;
        for (int m = 0; m < M; ++m) {
            EMCNode<S> node = new EMCNode<S>(m, "", 0, K, M, Km, seed1, seed2, kernel, false, processor, schedule);
            this.nodes.add(node);
        }
    }

    public void resampleAndAllocate() {
        this.numMsgs = new AtomicInteger(0);
        this.sums = new double[this.M];
        EMCNode.normalizeWeights(this.weightMsgs, this.sums, this.K);
        Parallelizer<Integer> parallelizer = new Parallelizer<Integer>(this.M);
        parallelizer.setPrimaryThread();
        parallelizer.process(CollUtils.ints(this.M), new Parallelizer.Processor<Integer>(){

            @Override
            public void process(Integer m, int i, int n, boolean log) {
                EMCNode node = (EMCNode)SimulateEMC.this.nodes.get(m);
                node.resampleAndAllocate(SimulateEMC.this.weightMsgs, SimulateEMC.this.sums);
                SimulateEMC.this.numMsgs.addAndGet(1);
                while (SimulateEMC.this.numMsgs.get() < SimulateEMC.this.M) {
                    Thread.yield();
                }
            }
        });
    }

    public void propagate() {
        this.numMsgs = new AtomicInteger(0);
        Parallelizer<Integer> parallelizer = new Parallelizer<Integer>(this.M);
        parallelizer.setPrimaryThread();
        parallelizer.process(CollUtils.ints(this.M), new Parallelizer.Processor<Integer>(){

            @Override
            public void process(Integer m, int i, int n, boolean log) {
                Message msg;
                EMCNode node = (EMCNode)SimulateEMC.this.nodes.get(m);
                ((SimulateEMC)SimulateEMC.this).weightMsgs[m.intValue()] = msg = node.propagate();
                SimulateEMC.this.numMsgs.addAndGet(1);
                while (SimulateEMC.this.numMsgs.get() < SimulateEMC.this.M) {
                    Thread.yield();
                }
            }
        });
    }

    public static enum Allocation {
        FirstOpen,
        MostAvailable,
        Random,
        Chaos;

    }
}

