/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.EMCParticle;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class TransferExperiment<S> {
    private double grandTotal = 0.0;
    private double subTotal = 0.0;

    public void measureSize(EMCParticle<S> particle) {
        File file = new File("temp_particle.file");
        ObjectOutputStream oos = IOUtils.openBinOutEasy(file);
        try {
            oos.writeObject(particle);
            oos.close();
            double filelength = file.length();
            LogInfo.logs("The particle " + particle.getId() + " has size=" + filelength + " bytes.");
            this.grandTotal += filelength;
            this.subTotal += filelength;
            LogInfo.logs("Grand total=" + this.grandTotal);
            LogInfo.logs("Sub total=" + this.subTotal);
            file.delete();
        }
        catch (IOException e) {
            LogInfo.logs(e);
        }
    }

    public void measureSize(S sample) {
        File file = new File("temp_particle.file");
        ObjectOutputStream oos = IOUtils.openBinOutEasy(file);
        try {
            oos.writeObject(sample);
            oos.close();
            double filelength = file.length();
            LogInfo.logs("The sample has size=" + filelength + " bytes.");
            this.grandTotal += filelength;
            this.subTotal += filelength;
            LogInfo.logs("Grand total=" + this.grandTotal);
            LogInfo.logs("Sub total=" + this.subTotal);
            file.delete();
        }
        catch (IOException e) {
            LogInfo.logs(e);
            throw new RuntimeException();
        }
    }

    public double clearSubTotal() {
        double temp = this.subTotal;
        this.subTotal = 0.0;
        return temp;
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }
}

