/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileException;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.Trail;
import fig.exec.servlet.Value;
import fig.exec.servlet.WebState;
import java.io.IOException;

public class ObjFileItem
extends FileItem {
    protected Object obj;

    public ObjFileItem(Trail trail, FileSource source) {
        super(trail, source);
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("class")) {
            return this.obj == null ? new Value(null) : new Value(this.obj.getClass().toString());
        }
        return super.getFieldValue(name);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = super.getMetadataFields();
        fields.add(new Field("class", "Class name"));
        return fields;
    }

    public void load() throws MyException {
        if (this.obj != null) {
            return;
        }
        if (this.fileSize > 0xA00000L) {
            throw new MyException("File too big to load: " + Fmt.bytesToString(this.fileSize));
        }
        WebState.logs("Loading object " + this.source.getPath());
        try {
            this.obj = IOUtils.readObjFile(this.source.getPath());
        }
        catch (ClassNotFoundException e) {
            throw new MyException(e.getMessage());
        }
        catch (IOException e) {
            throw new FileException(e);
        }
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.getOp();
        if (op.equals("load")) {
            this.load();
            return new ResponseParams("Loaded.");
        }
        return super.handleOperation(req, perm);
    }

    public Object getObj() {
        return this.obj;
    }
}

