/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.basic.StrUtils;
import fig.record.BufferedReceiver;
import fig.record.CommandEnv;
import fig.record.CommandNode;
import fig.record.CommandProcessor;
import fig.record.CommandUtils;
import fig.record.FullRecordNode;
import fig.record.GlobalEnv;
import fig.record.LocalCommandEnv;
import fig.record.PathRecordNode;
import fig.record.ReceiverInterface;
import fig.record.RecordNode;
import fig.record.RecordNodeUtils;
import fig.record.RecordServerInterface;
import fig.record.ResultReceiver;
import fig.record.TwigRecordNode;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

public class RecordServer
extends UnicastRemoteObject
implements RecordServerInterface {
    private RecordNode root = new FullRecordNode(null, null);
    private GlobalEnv globalEnv = new GlobalEnv(this.root);

    public RecordServer(String rootPath) throws RemoteException {
        this.root.addChild(PathRecordNode.newPathNode(null, this.globalEnv.getLoadFileState(), rootPath));
    }

    @Override
    public String getPrompt() throws RemoteException {
        return "> ";
    }

    @Override
    public ResultReceiver processCommand(String line, ReceiverInterface receiver) throws RemoteException {
        if (StrUtils.isEmpty(line)) {
            return null;
        }
        boolean useCallback = receiver != null;
        CommandEnv cmdEnv = new CommandEnv(this.globalEnv, receiver = useCallback ? new BufferedReceiver(receiver) : new ResultReceiver());
        CommandNode cmd = CommandUtils.parse(line, cmdEnv);
        if (cmd == null) {
            return null;
        }
        if (this.globalEnv.verbose(2)) {
            try {
                RecordNodeUtils.sendRecordNodetoReceiver(new TwigRecordNode(null, null, cmd), cmdEnv.getReceiver());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        RecordNode result = cmd.exec(new LocalCommandEnv(cmdEnv));
        RecordNodeUtils.sendRecordNodetoReceiver(result, receiver);
        cmdEnv.sendMandateToReceiver();
        cmdEnv.finish();
        receiver.flush();
        return useCallback ? null : (ResultReceiver)receiver;
    }

    public static void main(String[] args) {
        Options options = new Options();
        if (!new OptionsParser().doRegister("main", options).doParse(args)) {
            return;
        }
        try {
            RecordServer server = new RecordServer(options.rootPath);
            new CommandProcessor((RecordServerInterface)server, options.baseTempDir, false, false).processCommandFiles(options.commandFiles);
            Naming.rebind("RecordServer/" + options.id, server);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class Options {
        @Option(gloss="The root directory.")
        public String rootPath = ".";
        @Option(gloss="Command files to process.")
        public ArrayList<String> commandFiles = new ArrayList();
        @Option(gloss="Temporary directory")
        public String baseTempDir = "tmp";
        @Option(gloss="Identifier of this record server instance.", required=true)
        public String id;
    }
}

