/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.ParamsTracker;
import goblin.ParamsTrackers;
import java.util.ArrayList;
import java.util.Random;
import nuts.util.Arbre;
import nuts.util.Tree;
import pepper.Corpus;

public class PrepareTestData
implements Runnable {
    @Option(required=true)
    public String paramsPath;
    @Option(required=true)
    public String topo;
    @Option(required=true)
    public String wordsPath;
    @Option(required=true)
    public String outputPath;
    @Option
    Random rand = new Random(1L);

    @Override
    public void run() {
        try {
            ParamsTracker params = ParamsTrackers.restoreParamsTracker(this.paramsPath);
            Tree<String> topology = DataPrepUtils.lisp2tree(this.topo);
            LogInfo.logss("Topology: " + topology.toString());
            Corpus corpus = Corpus.parse(this.wordsPath);
            ArrayList<Arbre<DerivationTree.DerivationNode>> result = new ArrayList<Arbre<DerivationTree.DerivationNode>>();
            for (int row = 0; row < corpus.getNWords(); ++row) {
                Arbre<DerivationTree.DerivationNode> current = DataPrepUtils.tree2arbre(topology, corpus.getWords(row));
                Arbre<DerivationTree.DerivationNode> withSampledDerivs = DataPrepUtils.sampleDerivationsUsingObservedSampler(current, params, this.rand);
                result.add(withSampledDerivs);
            }
            DerivationTree.saveDerivation(result, this.outputPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Execution.run(args, new PrepareTestData());
    }
}

