/*
 * Decompiled with CFR 0.152.
 */
package javaxtools.compiler.examples.plotter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javaxtools.compiler.CharSequenceCompiler;
import javaxtools.compiler.CharSequenceCompilerException;
import javaxtools.compiler.examples.plotter.Function;

public final class PlotterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FUNCTION = "x * (sin(x) + cos(x))";
    private static final int PAD = 5;
    private final CharSequenceCompiler<Function> compiler = new CharSequenceCompiler(this.getClass().getClassLoader(), Arrays.asList("-target", "1.5"));
    private int classNameSuffix = 0;
    public static final String PACKAGE_NAME = "javaxtools.compiler.examples.plotter.runtime";
    private static final Random random = new Random();
    private String template;
    private Function function;
    private final PlotPanel plotPanel = new PlotPanel();
    private final JTextArea errors = new JTextArea();
    private final JTextField plotFunctionText = new JTextField("x * (sin(x) + cos(x))", 40);
    static final Function NULL_FUNCTION = new Function(){

        @Override
        public double f(double x) {
            return 0.0;
        }
    };

    public static void main(String[] args) {
        new PlotterPanel().setVisible(true);
    }

    public PlotterPanel() {
        PlotterPanel c = this;
        SpringLayout layout = new SpringLayout();
        c.setLayout(layout);
        JLabel label = new JLabel("f(x)=");
        JButton plotButton = new JButton("Plot this function");
        c.add(label);
        c.add(this.plotFunctionText);
        c.add(plotButton);
        ActionListener plot = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent action) {
                PlotterPanel.this.generateAndPlotFunction();
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PlotterPanel.this.generateAndPlotFunction();
            }
        });
        plotButton.addActionListener(plot);
        this.plotFunctionText.addActionListener(plot);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.errors);
        this.add(this.plotPanel);
        c.add(scrollPane);
        layout.putConstraint("North", (Component)label, 5, "North", (Component)c);
        layout.putConstraint("North", (Component)plotButton, 5, "North", (Component)c);
        layout.putConstraint("North", (Component)this.plotFunctionText, 5, "North", (Component)c);
        layout.putConstraint("West", (Component)label, 5, "West", (Component)c);
        layout.putConstraint("East", (Component)plotButton, -5, "East", (Component)c);
        layout.putConstraint("West", (Component)this.plotFunctionText, 5, "East", (Component)label);
        layout.putConstraint("East", (Component)this.plotFunctionText, -5, "West", (Component)plotButton);
        layout.putConstraint("East", (Component)this.plotPanel, -5, "East", (Component)c);
        layout.putConstraint("West", (Component)this.plotPanel, 5, "West", (Component)c);
        layout.putConstraint("North", (Component)this.plotPanel, 5, "South", (Component)plotButton);
        layout.putConstraint("South", (Component)this.plotPanel, -5, "North", (Component)scrollPane);
        layout.putConstraint("North", (Component)scrollPane, 5, "South", (Component)this.plotPanel);
        layout.putConstraint("East", (Component)scrollPane, -5, "East", (Component)c);
        layout.putConstraint("West", (Component)scrollPane, 5, "West", (Component)c);
        layout.putConstraint("South", (Component)scrollPane, -5, "South", (Component)c);
        layout.putConstraint("North", (Component)scrollPane, -40, "South", (Component)c);
        this.setPreferredSize(new Dimension(800, 600));
    }

    void generateAndPlotFunction() {
    }

    public Function newFunction(String expr) {
        this.errors.setText("");
        try {
            String packageName = PACKAGE_NAME + this.digits();
            String className = "Fx_" + this.classNameSuffix++ + this.digits();
            String qName = packageName + '.' + className;
            String source = this.fillTemplate(packageName, className, expr);
            DiagnosticCollector<JavaFileObject> errs = new DiagnosticCollector<JavaFileObject>();
            Class<Function> compiledFunction = this.compiler.compile(qName, source, errs, Function.class);
            this.log(errs);
            return compiledFunction.newInstance();
        }
        catch (CharSequenceCompilerException e) {
            this.log(e.getDiagnostics());
        }
        catch (InstantiationException e) {
            this.errors.setText(e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.errors.setText(e.getMessage());
        }
        catch (IOException e) {
            this.errors.setText(e.getMessage());
        }
        return NULL_FUNCTION;
    }

    private String digits() {
        return '_' + Long.toHexString(random.nextLong());
    }

    private String fillTemplate(String packageName, String className, String expression) throws IOException {
        if (this.template == null) {
            this.template = this.readTemplate();
        }
        String source = this.template.replace("$packageName", packageName).replace("$className", className).replace("$expression", expression);
        return source;
    }

    private String readTemplate() throws IOException {
        byte[] bytes;
        InputStream is = PlotterPanel.class.getResourceAsStream("Function.java.template");
        int size = is.available();
        if (size != is.read(bytes = new byte[size], 0, size)) {
            throw new IOException();
        }
        return new String(bytes, "US-ASCII");
    }

    private void log(DiagnosticCollector<JavaFileObject> diagnostics) {
        StringBuilder msgs = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            msgs.append(diagnostic.getMessage(null)).append("\n");
        }
        this.errors.setText(msgs.toString());
    }

    static class PlotPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        BufferedImage image;

        PlotPanel() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            } else {
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

