/*
 * Decompiled with CFR 0.152.
 */
package nuts.io;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import nuts.io.IteratorWrapper;

public class CSVReaderIterator
implements Iterator<List<String>> {
    private CSVReader reader = null;
    private List<String> currentLine = null;
    boolean closed = false;

    public CSVReaderIterator(BufferedReader r) {
        this(new CSVReader((Reader)r));
    }

    public CSVReaderIterator(CSVReader r) {
        this.reader = r;
    }

    @Override
    public boolean hasNext() {
        if (this.currentLine != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        try {
            String[] cur = this.reader.readNext();
            if (cur == null) {
                this.currentLine = null;
                this.reader.close();
                this.closed = true;
                return false;
            }
            this.currentLine = Arrays.asList(cur);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Error while reading file.");
        }
    }

    @Override
    public List<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<String> result = this.currentLine;
        this.currentLine = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<List<String>> iterate(BufferedReader r) {
        return IteratorWrapper.IW(new CSVReaderIterator(r));
    }
}

