/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.StrUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import nuts.io.IO;
import nuts.ling.TIPAConversion;
import nuts.tui.Table;
import nuts.util.EasyFormat;

public class CSV2Latex
implements Runnable {
    @Option(required=true)
    public String file;
    @Option
    public String align = "l";
    @Option
    public boolean firstLineIsHeader = true;
    @Option
    public ArrayList<Integer> columnsToTipafy = new ArrayList();
    @Option
    public ArrayList<Integer> columnsToFormat = new ArrayList();
    @Option
    public boolean useSuperTabularTable = true;
    @Option
    public boolean addReconMark = true;
    @Option
    public String outFile = "-";
    private PrintWriter out = null;

    private PrintWriter getWriter() {
        if (this.out == null) {
            this.out = IOUtils.openOutHard(this.outFile);
        }
        return this.out;
    }

    public static void main(String[] args) {
        IO.runLight(args, new CSV2Latex());
    }

    public void so(String line) {
        if (this.outFile.equals("-")) {
            IO.so(line);
        } else {
            this.getWriter().println(line);
        }
    }

    @Override
    public void run() {
        int nCols = -1;
        Table t = new Table();
        if (this.useSuperTabularTable && !this.firstLineIsHeader) {
            throw new RuntimeException();
        }
        int row = 0;
        for (List<String> line : IO.iCSV(this.file)) {
            if (nCols == -1) {
                nCols = line.size();
                if (!this.useSuperTabularTable) {
                    this.so(CSV2Latex.header(nCols, this.align));
                }
            } else if (nCols != line.size()) {
                throw new RuntimeException();
            }
            if (this.useSuperTabularTable && row == 0) {
                this.so(CSV2Latex.superHeader(line, this.align));
            } else {
                for (int col = 0; col < nCols; ++col) {
                    String current = line.get(col);
                    if (this.columnsToTipafy.contains(col) && (row > 0 || !this.firstLineIsHeader)) {
                        current = (this.addReconMark ? "*" : "") + "\\textipa{" + TIPAConversion.convert(current) + "}";
                    }
                    if (this.columnsToFormat.contains(col) && (row > 0 || !this.firstLineIsHeader)) {
                        current = EasyFormat.fmt2(Double.parseDouble(current));
                    }
                    t.set(row, col, (col != 0 ? " & " : "") + current + (col == nCols - 1 ? "\\\\" : ""));
                }
                if (row == 0 && this.firstLineIsHeader) {
                    t.set(++row, 0, "\\hline");
                }
            }
            ++row;
        }
        t.setBorder(false);
        this.so("" + t);
        if (this.useSuperTabularTable) {
            this.so(CSV2Latex.superFooter());
        } else {
            this.so("\\end{tabular}");
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public static String superFooter() {
        return "\\end{supertabular} \n \\end{center}";
    }

    public static String header(int nCols, String align) {
        return "\\begin{tabular}{ " + StrUtils.repeat(align + " ", nCols) + " }";
    }

    public static String superHeader(List<String> headerLine, String align) {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{center}\n");
        result.append("\\tablefirsthead{\n");
        result.append("\\toprule\n");
        result.append(StrUtils.join(headerLine, " & ") + "\\\\ \n");
        result.append("\\midrule}\n");
        result.append("\\tablehead{\n");
        result.append("\\toprule \n");
        result.append("\\multicolumn{" + headerLine.size() + "}{l}{\\small\\sl continued from previous page}\\\\ \n");
        result.append("\\midrule \n");
        result.append(StrUtils.join(headerLine, " & ") + "\\\\ \n");
        result.append("\\midrule}\n");
        result.append("\\tabletail{ \n");
        result.append("\\toprule \n");
        result.append("\\multicolumn{" + headerLine.size() + "}{r}{\\small\\sl continued on next page}\\\\ \n");
        result.append("\\bottomrule} \n");
        result.append("\\tablelasttail{\\hline} \n");
        result.append("%\\bottomcaption{This table is split across pages}\n");
        result.append("\\begin{supertabular}{" + StrUtils.repeat(align + " ", headerLine.size()) + "} \n");
        return result.toString();
    }
}

