/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.util.Arrays;
import nuts.math.Graphs;

public final class CoordinatesPacker {
    public final int L;
    public final int D;
    private final int size;

    public CoordinatesPacker(int L, int D) {
        this.L = L;
        this.D = D;
        this.size = (int)Math.pow(L, D);
    }

    public CoordinatesPacker(int L) {
        this.L = L;
        this.D = 2;
        this.size = L * L;
    }

    public int[] int2coord(int coord) {
        return Graphs.Grid.int2coord(coord, this.D, this.L);
    }

    public int coord2int(int ... coord) {
        return Graphs.Grid.coord2int(coord, this.D, this.L);
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] args) {
        int[] size = new int[]{2, 3, 5, 2};
        int init = 60;
        MSCoordinatePacker mscp = new MSCoordinatePacker(size);
        int[] coord = mscp.int2coord(init);
        System.out.println(Arrays.toString(coord));
        System.out.println(mscp.coord2int(coord));
    }

    public static class MSCoordinatePacker {
        private final int[] sizes;
        public final int max;

        public int size() {
            return this.max;
        }

        public MSCoordinatePacker(int[] sizes) {
            this.sizes = sizes;
            int prod = 1;
            for (int size : sizes) {
                prod *= size;
            }
            this.max = prod;
        }

        public int[] int2coord(int integer) {
            if (integer < 0 || integer >= this.max) {
                throw new RuntimeException();
            }
            int[] result = new int[this.sizes.length];
            for (int d = 0; d < result.length; ++d) {
                result[d] = integer % this.sizes[d];
                integer /= this.sizes[d];
            }
            return result;
        }

        public int coord2int(int ... coord) {
            if (coord.length != this.sizes.length) {
                throw new RuntimeException();
            }
            int result = 0;
            int cPow = 1;
            for (int d = 0; d < this.sizes.length; ++d) {
                if (coord[d] < 0 || coord[d] >= this.sizes[d]) {
                    throw new RuntimeException();
                }
                result += cPow * coord[d];
                cPow *= this.sizes[d];
            }
            return result;
        }
    }
}

