/*
 * Decompiled with CFR 0.152.
 */
package pedi;

import java.util.HashSet;
import java.util.List;
import nuts.util.CollUtils;
import nuts.util.CoordinatesPacker;
import pedi.Genotype;
import pedi.factor.FactorEncodings;
import pedi.factor.PedigreeNode;

public class BiAllelicDiploidGenotype
implements Genotype {
    private final List<Integer> rawImport;
    public static final CoordinatesPacker haplotypePacker = new CoordinatesPacker(2, 2);
    public static final CoordinatesPacker marriagePacker = new CoordinatesPacker(4, 2);
    public static final CoordinatesPacker.MSCoordinatePacker inheritancePacker = new CoordinatesPacker.MSCoordinatePacker(new int[]{2, 2, 4});
    public static final FactorEncodings biAllelicAutosomalEncodings = BiAllelicDiploidGenotype.buildBiAllelicAutosomalEncodings();

    public BiAllelicDiploidGenotype(List<Integer> rawImport) {
        this.rawImport = rawImport;
    }

    @Override
    public double[][] getUnaryFactor() {
        return BiAllelicDiploidGenotype.raw2UnaryFactor(this.rawImport);
    }

    public int getHeldoutHaplotype(int index, int chrFrom) {
        int raw = this.rawImport.get(2 * index + chrFrom);
        if (raw != 1 && raw != 2 && raw != 0) {
            throw new RuntimeException();
        }
        return raw - 1;
    }

    public double[][] getHeldoutAlleleIndicator(int chrFrom) {
        double[][] result = new double[this.genomeSize()][2];
        for (int site = 0; site < this.genomeSize(); ++site) {
            result[site][this.getHeldoutHaplotype((int)site, (int)chrFrom)] = 1.0;
        }
        return result;
    }

    public int genomeSize() {
        return this.rawImport.size() / 2;
    }

    public static double[][] raw2UnaryFactor(List<Integer> raw) {
        if (raw.size() % 2 != 0) {
            throw new RuntimeException();
        }
        int firstHomoz = biAllelicAutosomalEncodings.haplotypeCode(0, 0);
        int secondHomoz = biAllelicAutosomalEncodings.haplotypeCode(1, 1);
        int firstHeteroz = biAllelicAutosomalEncodings.haplotypeCode(0, 1);
        int secondHeteroz = biAllelicAutosomalEncodings.haplotypeCode(1, 0);
        int genomeLen = raw.size() / 2;
        int nHaplotypes = biAllelicAutosomalEncodings.nHaplotypes();
        double[][] result = new double[genomeLen][nHaplotypes];
        for (int site = 0; site < genomeLen; ++site) {
            HashSet<Integer> set = new HashSet<Integer>(2);
            set.add(raw.get(2 * site));
            set.add(raw.get(2 * site + 1));
            if (set.size() == 1) {
                int item = (Integer)CollUtils.pick(set);
                if (item == 0) {
                    for (int h = 0; h < nHaplotypes; ++h) {
                        result[site][h] = 1.0;
                    }
                    continue;
                }
                if (item == 1) {
                    result[site][firstHomoz] = 1.0;
                    continue;
                }
                if (item != 2) continue;
                result[site][secondHomoz] = 1.0;
                continue;
            }
            if (set.contains(0)) {
                throw new RuntimeException();
            }
            result[site][firstHeteroz] = 1.0;
            result[site][secondHeteroz] = 1.0;
        }
        return result;
    }

    @Override
    public FactorEncodings getInheritanceEncodings() {
        return biAllelicAutosomalEncodings;
    }

    private static final FactorEncodings buildBiAllelicAutosomalEncodings() {
        FactorEncodings result = new FactorEncodings(haplotypePacker);
        for (int code = 0; code < 2; ++code) {
            result.set(PedigreeNode.PedigreeNodeType.HAPLOTYPE, PedigreeNode.PedigreeNodeType.MARRIAGE, code, BiAllelicDiploidGenotype.buildHaplotype2Marriage(code));
            result.set(PedigreeNode.PedigreeNodeType.INHERITANCE, PedigreeNode.PedigreeNodeType.RECOMB, code, BiAllelicDiploidGenotype.buildInheritance2Recom(code));
            result.set(PedigreeNode.PedigreeNodeType.HAPLOTYPE, PedigreeNode.PedigreeNodeType.INHERITANCE, code, BiAllelicDiploidGenotype.buildHaplotype2Inheritance(code));
            result.set(PedigreeNode.PedigreeNodeType.HAPLOTYPE, PedigreeNode.PedigreeNodeType.ALLELE_PRESENCE, code, BiAllelicDiploidGenotype.buildHaplotype2AllelePresence(code));
            result.set(PedigreeNode.PedigreeNodeType.HAPLOTYPE, PedigreeNode.PedigreeNodeType.ALLELE, code, BiAllelicDiploidGenotype.buildHaplotype2Allele(code));
        }
        result.set(PedigreeNode.PedigreeNodeType.MARRIAGE, PedigreeNode.PedigreeNodeType.INHERITANCE, BiAllelicDiploidGenotype.buildMarriage2Inheritance());
        result.set(PedigreeNode.PedigreeNodeType.INHERITANCE, PedigreeNode.PedigreeNodeType.HAPLOTYPE, BiAllelicDiploidGenotype.buildInheritance2Haplotype());
        return result;
    }

    public static final int getAlleleFromHaplotype(int hCode, int chromosomeInheritedFrom) {
        return haplotypePacker.int2coord(hCode)[chromosomeInheritedFrom];
    }

    public static final int getHaplotypeFromMarriage(int mCode, int parent) {
        return marriagePacker.int2coord(mCode)[parent];
    }

    public static final int getHaplotypeFromInheritance(int iCode) {
        int result = inheritancePacker.int2coord(iCode)[2];
        return result;
    }

    public static final int getRecombFromInheritance(int iCode, int parent) {
        if (parent != 0 && parent != 1) {
            throw new RuntimeException();
        }
        return inheritancePacker.int2coord(iCode)[parent];
    }

    public static double[][] buildHaplotype2Marriage(int parent) {
        double[][] result = new double[haplotypePacker.size()][marriagePacker.size()];
        for (int hCode = 0; hCode < haplotypePacker.size(); ++hCode) {
            for (int mCode = 0; mCode < marriagePacker.size(); ++mCode) {
                result[hCode][mCode] = hCode == BiAllelicDiploidGenotype.getHaplotypeFromMarriage(mCode, parent) ? 1.0 : 0.0;
            }
        }
        return result;
    }

    public static double[][] buildHaplotype2AllelePresence(int alleleCode) {
        double[][] result = new double[haplotypePacker.size()][2];
        for (int hCode = 0; hCode < haplotypePacker.size(); ++hCode) {
            int a0 = BiAllelicDiploidGenotype.getAlleleFromHaplotype(hCode, 0);
            int a1 = BiAllelicDiploidGenotype.getAlleleFromHaplotype(hCode, 1);
            int cur = 0;
            if (alleleCode == 0 && (a0 == 0 || a1 == 0)) {
                cur = 1;
            }
            if (alleleCode == 1 && (a0 == 1 || a1 == 1)) {
                cur = 1;
            }
            result[hCode][0] = 1 - cur;
            result[hCode][1] = cur;
        }
        return result;
    }

    public static double[][] buildHaplotype2Allele(int chrFrom) {
        double[][] result = new double[haplotypePacker.size()][2];
        for (int hCode = 0; hCode < haplotypePacker.size(); ++hCode) {
            int alleleCode = BiAllelicDiploidGenotype.getAlleleFromHaplotype(hCode, chrFrom);
            result[hCode][alleleCode] = 1.0;
        }
        return result;
    }

    public static double[][] buildMarriage2Inheritance() {
        double[][] result = new double[marriagePacker.size()][inheritancePacker.size()];
        for (int mCode = 0; mCode < marriagePacker.size(); ++mCode) {
            for (int iCode = 0; iCode < inheritancePacker.size(); ++iCode) {
                result[mCode][iCode] = BiAllelicDiploidGenotype.inheritancePair(iCode, BiAllelicDiploidGenotype.getHaplotypeFromMarriage(mCode, 0), BiAllelicDiploidGenotype.getHaplotypeFromMarriage(mCode, 1));
            }
        }
        return result;
    }

    public static double inheritancePair(int iCode, int parentHapCode0, int parentHapCode1) {
        double result = 1.0;
        for (int parent = 0; parent < 2; ++parent) {
            result *= BiAllelicDiploidGenotype.inheritance(iCode, parent, parent == 0 ? parentHapCode0 : parentHapCode1);
        }
        return result;
    }

    public static double inheritance(int iCode, int parent, int parentHapCode) {
        int childAllele;
        int childHCode = BiAllelicDiploidGenotype.getHaplotypeFromInheritance(iCode);
        int recomb = BiAllelicDiploidGenotype.getRecombFromInheritance(iCode, parent);
        int parentAllele = BiAllelicDiploidGenotype.getAlleleFromHaplotype(parentHapCode, recomb);
        return parentAllele == (childAllele = BiAllelicDiploidGenotype.getAlleleFromHaplotype(childHCode, parent)) ? 1.0 : 0.0;
    }

    public static double[][] buildInheritance2Haplotype() {
        double[][] result = new double[inheritancePacker.size()][haplotypePacker.size()];
        for (int iCode = 0; iCode < inheritancePacker.size(); ++iCode) {
            for (int hCode = 0; hCode < haplotypePacker.size(); ++hCode) {
                result[iCode][hCode] = BiAllelicDiploidGenotype.getHaplotypeFromInheritance(iCode) == hCode ? 1.0 : 0.0;
            }
        }
        return result;
    }

    public static double[][] buildInheritance2Recom(int chrInhFrom) {
        double[][] result = new double[inheritancePacker.size()][2];
        for (int iCode = 0; iCode < inheritancePacker.size(); ++iCode) {
            for (int rCode = 0; rCode < 2; ++rCode) {
                result[iCode][rCode] = BiAllelicDiploidGenotype.getRecombFromInheritance(iCode, chrInhFrom) == rCode ? 1.0 : 0.0;
            }
        }
        return result;
    }

    public static double[][] buildHaplotype2Inheritance(int parent) {
        double[][] result = new double[haplotypePacker.size()][inheritancePacker.size()];
        for (int hCode = 0; hCode < haplotypePacker.size(); ++hCode) {
            for (int iCode = 0; iCode < inheritancePacker.size(); ++iCode) {
                result[hCode][iCode] = BiAllelicDiploidGenotype.inheritance(iCode, parent, hCode);
            }
        }
        return result;
    }

    public void removeEvenMarkers() {
        for (int gPos = 0; gPos < this.genomeSize(); ++gPos) {
            if (gPos % 2 != 0) continue;
            for (int idx = 0; idx < 2; ++idx) {
                this.rawImport.set(2 * gPos + idx, 0);
            }
        }
    }

    public void setHiddenMarkersToOne(int exception) {
        for (int gPos = 0; gPos < this.genomeSize(); ++gPos) {
            if (gPos % 2 != 0 || gPos == exception) continue;
            for (int idx = 0; idx < 2; ++idx) {
                this.rawImport.set(2 * gPos + idx, 1);
            }
        }
    }
}

