/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.NumUtils;
import fig.prob.SampleUtils;
import java.util.Random;

public class Ehrenfest {
    private int N = 100;
    private int n = 0;
    private Random rand = new Random();
    private int burnIn = 100000;
    private int t = 0;
    double totalRec = 0.0;
    double numRec = 0.0;
    double lastRec = -1.0;

    public static void main(String[] args) {
        Ehrenfest mc = new Ehrenfest();
        mc.sample(1000000);
        System.out.println(mc.meanRec());
    }

    public void sample(int iters) {
        this.t = 0;
        while (this.t < iters) {
            this.n = this.trans();
            if (this.t > this.burnIn && (double)this.n == (double)this.N / 2.0) {
                this.recordRec();
            }
            ++this.t;
        }
    }

    private void recordRec() {
        if (this.lastRec == -1.0) {
            this.lastRec = this.t;
            return;
        }
        this.totalRec += (double)this.t - this.lastRec;
        this.numRec += 1.0;
        this.lastRec = this.t;
    }

    public double meanRec() {
        return this.totalRec / this.numRec;
    }

    public int trans() {
        double[] prs;
        prs = new double[]{1.0 - (double)this.n / (double)this.N, 1.0 - prs[0]};
        NumUtils.assertNormalized(prs);
        int decision = SampleUtils.sampleMultinomial(this.rand, prs);
        if (decision == 0) {
            return this.n + 1;
        }
        return this.n - 1;
    }
}

