/*
 * Decompiled with CFR 0.152.
 */
package smc;

import conifer.apps.AbstractPhyloApp;
import ev.ex.GetPhylogeneticKernel;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.LogInfo;
import fig.basic.Option;
import gep.util.OutputManager;
import java.util.Random;
import nuts.io.IO;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.EntangledParticle;
import smc.EntangledRandom;

public class PhyloEntangled
extends AbstractPhyloApp
implements Runnable {
    @Option(required=true)
    public int nTax;
    @Option(required=true)
    public int nSites;
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public int machineId;
    @Option(required=true)
    public EntangledParticle.ParticleAllocationStyle allocationStyle;
    @Option(required=true)
    public Random rand1 = new Random(1L);
    @Option(required=true)
    public Random rand2 = new Random(1L);
    private TreeDistancesProcessorWrapper processor;

    public static void main(String[] args) {
        IO.run(args, new PhyloEntangled());
    }

    @Override
    public void run() {
        LogInfo.logs("machine=" + this.machineId + " starting");
        int[][] config = new int[2][this.numMachines];
        int numParticlesPerMachine = this.N / this.numMachines;
        for (int k = 0; k < this.numMachines; ++k) {
            config[0][k] = numParticlesPerMachine;
            config[1][k] = (int)Math.ceil((double)numParticlesPerMachine * 1.1);
        }
        LogInfo.logs("config=" + config[0][0]);
        LogInfo.logs("capacity=" + config[1][0]);
        ParticleKernel<PartialCoalescentState> kernel = GetPhylogeneticKernel.getPhyloKernel(this.nTax, this.nSites);
        int T = kernel.nIterationsLeft(kernel.getInitial());
        EntangledRandom eRandom = new EntangledRandom(this.machineId, this.N, T, this.rand1, this.rand2);
        this.processor = new TreeDistancesProcessorWrapper(T, this.numMachines);
        EntangledParticle<PartialCoalescentState> entangled = EntangledParticle.run(kernel, this.processor, eRandom, this.machineId, config, this.N, this.allocationStyle, null);
        entangled.printStatistics();
        this.processor.printStatistics();
    }

    public static class TreeDistancesProcessorWrapper
    implements ParticleFilter.ParticleProcessor<PartialCoalescentState> {
        private TreeDistancesProcessor processor = new TreeDistancesProcessor();
        private int[] stats;
        private int T;
        private int numMachines;

        public TreeDistancesProcessorWrapper(int T, int numMachines) {
            this.numMachines = numMachines;
            this.stats = new int[T];
        }

        @Override
        public void process(PartialCoalescentState state, double weight) {
            int t;
            int nNonTrivial = state.nNonTrivialRoots();
            int n = t = state.generationIndex();
            this.stats[n] = this.stats[n] + nNonTrivial;
            LogInfo.logs("numNonTrivial=" + nNonTrivial + " at t=" + t);
        }

        public void printStatistics() {
            OutputManager writer = new OutputManager();
            for (int t = 0; t < this.stats.length; ++t) {
                Object[] context = new Object[]{"generation", t + "", "nt", this.stats[t]};
                writer.write("statistics_numMachines=" + this.numMachines, context);
            }
            writer.close();
        }
    }
}

