/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.Random;
import nuts.io.IO;
import parallel.Ising;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.DistributedSMC;

public class TestEntangledParticleIsing
implements Runnable {
    @Option
    public int L = 3;
    @Option
    public double alpha = 0.0;
    @Option
    public double temperature = 2.0;
    @Option
    public int numIter = 10;
    @Option
    public int N = 10;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public DistributedSMC.ParticleOptimizationStyle particleOptimizationStyle;

    @Override
    public void run() {
        int[][] machineConfig = new int[this.numMachines][2];
        int numParticlesPerMachine = this.N / this.numMachines;
        for (int k = 0; k < this.numMachines; ++k) {
            machineConfig[k][0] = numParticlesPerMachine;
            machineConfig[k][1] = numParticlesPerMachine;
        }
        IsingKernel kernel = new IsingKernel(this.L, this.numIter, this.temperature);
        IsingProcessor processor = new IsingProcessor(this.L, this.N, this.numIter);
        DistributedSMC<Ising> isingSMC = DistributedSMC.runDistributedSMC(this.numIter, this.N, kernel, machineConfig, processor, this.particleOptimizationStyle);
        processor.printEstimates();
    }

    public static void main(String[] args) {
        IO.run(args, new TestEntangledParticleIsing());
    }

    public static class IsingProcessor
    implements ParticleFilter.ParticleProcessor<Ising> {
        private int N = 0;
        private int l;
        private int numIter;
        private int numWhite = 0;
        private int numBlack = 0;
        private int[][] posterior;

        public IsingProcessor(int l, int N, int numIter) {
            this.l = l;
            this.numIter = numIter;
            this.N = N;
            this.posterior = new int[l][l];
            for (int r = 0; r < l; ++r) {
                for (int c = 0; c < l; ++c) {
                    this.posterior[r][c] = 0;
                }
            }
        }

        @Override
        public void process(Ising state, double weight) {
            int spins = state.countSpins();
            if (spins == this.l * this.l) {
                ++this.numWhite;
            } else if (spins == -this.l * this.l) {
                ++this.numBlack;
            }
            for (int r = 0; r < this.posterior.length; ++r) {
                for (int c = 0; c < this.posterior.length; ++c) {
                    if (state.getState(r, c) != -1) continue;
                    int[] nArray = this.posterior[r];
                    int n = c;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }

        public void printEstimates() {
            double estimate = 0.0;
            for (int r = 0; r < this.posterior.length; ++r) {
                StringBuffer sb = new StringBuffer();
                for (int c = 0; c < this.posterior.length; ++c) {
                    estimate = (double)this.posterior[r][c] / (double)this.N;
                    sb.append(estimate);
                    sb.append(" ");
                }
                LogInfo.logs(sb);
            }
            LogInfo.logs("numWhite=" + this.numWhite);
            LogInfo.logs("numBlack=" + this.numBlack);
        }
    }

    public static class IsingKernel
    implements ParticleKernel<Ising> {
        private double incr;
        private int l;
        public double temperature;

        public IsingKernel(int l, int numIter, double temperature) {
            this.l = l;
            this.incr = 1.0 / (double)numIter;
            this.temperature = temperature;
        }

        @Override
        public Pair<Ising, Double> next(Random rand, Ising model) {
            StringBuffer sb = new StringBuffer();
            double gammaOld = model.energy();
            Pair<Double, Double> pair = model.parallelStep(rand);
            double gammaNew = model.energy();
            sb.append("gammaNew=" + gammaNew + " gammaOld=" + gammaOld + " ");
            double weight = Math.exp(gammaNew - gammaOld);
            weight = Math.pow(weight, this.incr * (double)DistributedSMC.TIME);
            double pForward = pair.getFirst();
            double pBack = pair.getSecond();
            sb.append("rawWeight=" + weight + " pBack=" + pBack + " pForward=" + pForward + " ");
            weight = weight * pBack / pForward;
            weight = Math.log(weight);
            sb.append("logWeight=" + weight);
            if (!(weight <= 0.0) && !(weight > 0.0)) {
                LogInfo.logs("Unrecoverable error: weight=" + weight);
                System.exit(-1);
            }
            LogInfo.logs(sb.toString());
            Pair<Ising, Double> retval = new Pair<Ising, Double>(model, weight);
            return retval;
        }

        @Override
        public int nIterationsLeft(Ising partialState) {
            return 0;
        }

        @Override
        public Ising getInitial() {
            Ising model = new Ising(this.l, 0.0, this.temperature, 0);
            return model;
        }
    }
}

