/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DimensionException;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;

public abstract class AbstractComplexMatrix
extends Matrix {
    protected AbstractComplexMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractComplexMatrix) {
            return this.equals((AbstractComplexMatrix)object);
        }
        return false;
    }

    public final boolean equals(AbstractComplexMatrix abstractComplexMatrix) {
        return this.equals(abstractComplexMatrix, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix, double d) {
        if (abstractComplexMatrix != null && this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.getRealElement(i, j) - abstractComplexMatrix.getRealElement(i, j);
                    double d4 = this.getImagElement(i, j) - abstractComplexMatrix.getImagElement(i, j);
                    d2 += d3 * d3 + d4 * d4;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix real() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j).real();
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix imag() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j).imag();
            }
        }
        return new DoubleMatrix(dArray);
    }

    public abstract Complex getElement(int var1, int var2);

    public abstract double getRealElement(int var1, int var2);

    public abstract double getImagElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, Complex var3);

    public abstract void setElement(int var1, int var2, double var3, double var5);

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += this.getElement(i, j).norm();
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d += this.getRealElement(i, j) * this.getRealElement(i, j) + this.getImagElement(i, j) * this.getImagElement(i, j);
            }
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.getRealElement(i, 0);
            dArray2[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.getRealElement(i, j);
                dArray2[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.add((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix add(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getRealElement(i, 0) + abstractComplexMatrix.getRealElement(i, 0);
                dArray2[i][0] = this.getImagElement(i, 0) + abstractComplexMatrix.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getRealElement(i, j) + abstractComplexMatrix.getRealElement(i, j);
                    dArray2[i][j] = this.getImagElement(i, j) + abstractComplexMatrix.getImagElement(i, j);
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.subtract((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix subtract(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getRealElement(i, 0) - abstractComplexMatrix.getRealElement(i, 0);
                dArray2[i][0] = this.getImagElement(i, 0) - abstractComplexMatrix.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getRealElement(i, j) - abstractComplexMatrix.getRealElement(i, j);
                    dArray2[i][j] = this.getImagElement(i, j) - abstractComplexMatrix.getImagElement(i, j);
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.getRealElement(i, 0) - d2 * this.getImagElement(i, 0);
            dArray2[i][0] = d2 * this.getRealElement(i, 0) + d * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.getRealElement(i, j) - d2 * this.getImagElement(i, j);
                dArray2[i][j] = d2 * this.getRealElement(i, j) + d * this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.getRealElement(i, 0);
            dArray2[i][0] = d * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.getRealElement(i, j);
                dArray2[i][j] = d * this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            complexArray[i][0] = this.getElement(i, 0).divide(complex);
            for (int j = 1; j < this.numCols; ++j) {
                complexArray[i][j] = this.getElement(i, j).divide(complex);
            }
        }
        return new ComplexMatrix(complexArray);
    }

    public AbstractComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.getRealElement(i, 0) / d;
            dArray2[i][0] = this.getImagElement(i, 0) / d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.getRealElement(i, j) / d;
                dArray2[i][j] = this.getImagElement(i, j) / d;
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public Complex scalarProduct(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                d += this.getRealElement(i, 0) * abstractComplexMatrix.getRealElement(i, 0) + this.getImagElement(i, 0) * abstractComplexMatrix.getImagElement(i, 0);
                d2 += this.getImagElement(i, 0) * abstractComplexMatrix.getRealElement(i, 0) - this.getRealElement(i, 0) * abstractComplexMatrix.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    d += this.getRealElement(i, j) * abstractComplexMatrix.getRealElement(i, j) + this.getImagElement(i, j) * abstractComplexMatrix.getImagElement(i, j);
                    d2 += this.getImagElement(i, j) * abstractComplexMatrix.getRealElement(i, j) - this.getRealElement(i, j) * abstractComplexMatrix.getImagElement(i, j);
                }
            }
            return new Complex(d, d2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = this.getElement(i, 0).multiply(abstractComplexVector.getComponent(0));
                dArray[i] = complex.real();
                dArray2[i] = complex.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    complex = this.getElement(i, j).multiply(abstractComplexVector.getComponent(j));
                    int n = i;
                    dArray[n] = dArray[n] + complex.real();
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + complex.imag();
                }
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.multiply((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public AbstractComplexMatrix multiply(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numCols == abstractComplexMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexMatrix.columns()];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < abstractComplexMatrix.columns(); ++j) {
                    Complex complex = this.getElement(i, 0).multiply(abstractComplexMatrix.getElement(0, j));
                    dArray[i][j] = complex.real();
                    dArray2[i][j] = complex.imag();
                    for (int k = 1; k < this.numCols; ++k) {
                        complex = this.getElement(i, k).multiply(abstractComplexMatrix.getElement(k, j));
                        double[] dArray3 = dArray[i];
                        int n = j;
                        dArray3[n] = dArray3[n] + complex.real();
                        double[] dArray4 = dArray2[i];
                        int n2 = j;
                        dArray4[n2] = dArray4[n2] + complex.imag();
                    }
                }
            }
            if (this.numRows == abstractComplexMatrix.columns()) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix directSum(AbstractComplexMatrix abstractComplexMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.getRealElement(n2, n);
                dArray2[n2][n] = this.getImagElement(n2, n);
            }
        }
        for (n2 = 0; n2 < abstractComplexMatrix.numRows; ++n2) {
            for (n = 0; n < abstractComplexMatrix.numCols; ++n) {
                dArray[n2 + this.numRows][n + this.numCols] = abstractComplexMatrix.getRealElement(n2, n);
                dArray2[n2 + this.numRows][n + this.numCols] = abstractComplexMatrix.getImagElement(n2, n);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix tensor(AbstractComplexMatrix abstractComplexMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractComplexMatrix.numRows) {
                    for (int k = 0; k < abstractComplexMatrix.numCols; ++k) {
                        Complex complex = this.getElement(i, j).multiply(abstractComplexMatrix.getElement(n, k));
                        dArray[i * abstractComplexMatrix.numRows + n][j * abstractComplexMatrix.numCols + k] = complex.real();
                        dArray2[i * abstractComplexMatrix.numRows + n][j * abstractComplexMatrix.numCols + k] = complex.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.getRealElement(i, 0);
            dArray2[0][i] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.getRealElement(i, j);
                dArray2[j][i] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.getRealElement(i, 0);
            dArray2[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.getRealElement(i, j);
                dArray2[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.getRealElement(i, 0);
            dArray2[0][i] = this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.getRealElement(i, j);
                dArray2[j][i] = this.getImagElement(i, j);
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            complexArray[i][0] = complexMapping.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                complexArray[i][j] = complexMapping.map(this.getElement(i, j));
            }
        }
        return new ComplexMatrix(complexArray);
    }
}

