/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReflexionUtils {
    public static List<Field> getDeclaredFields(Class clazz, boolean recursively) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] declaredFields = clazz.getDeclaredFields();
        Collections.addAll(fields, declaredFields);
        Class superClass = clazz.getSuperclass();
        if (superClass != null && recursively) {
            fields.addAll(ReflexionUtils.getDeclaredFields(superClass, recursively));
        }
        return fields;
    }

    public static List<Field> getAnnotatedDeclaredFields(Class clazz, Class<? extends Annotation> annotationClass, boolean recursively) {
        List<Field> allFields = ReflexionUtils.getDeclaredFields(clazz, recursively);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static void setFieldValue(Field f, Object instance, Object value) {
        try {
            boolean isAccessible = f.isAccessible();
            if (!isAccessible) {
                f.setAccessible(true);
            }
            f.set(instance, value);
            if (!isAccessible) {
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Field f, Object instance) {
        try {
            boolean isAccessible = f.isAccessible();
            if (!isAccessible) {
                f.setAccessible(true);
            }
            Object result = f.get(instance);
            if (!isAccessible) {
                f.setAccessible(false);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            boolean isAccessible = constructor.isAccessible();
            if (!isAccessible) {
                constructor.setAccessible(true);
            }
            T result = constructor.newInstance(new Object[0]);
            if (!isAccessible) {
                constructor.setAccessible(false);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object callMethod(Object instance, String methodName) {
        try {
            Method method = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> sublistOfGivenType(List<?> originalList, Class<T> ofType) {
        ArrayList result = Lists.newArrayList();
        for (Object variable : originalList) {
            if (!ofType.isAssignableFrom(variable.getClass())) continue;
            result.add(variable);
        }
        return result;
    }
}

