/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.EMCCommException;
import comm.Message;
import emc.Timer;
import fig.basic.LogInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ProxyNode {
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private Socket socket;
    private String bootstrapIp;
    private int bootstrapPort;
    private Timer timer;
    private ServerSocket serverSocket;

    public ProxyNode(String bootstrapIp, int bootstrapPort) throws IOException {
        this.bootstrapIp = bootstrapIp;
        this.bootstrapPort = bootstrapPort;
        this.timer = new Timer();
    }

    public void sendMessageToServer(Message msg) throws IOException, ClassNotFoundException, EMCCommException {
        LogInfo.logs("Send message to the server");
        this.socket = new Socket(this.bootstrapIp, this.bootstrapPort);
        this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        this.oos.writeObject(msg);
        this.oos.flush();
        this.oos.close();
        this.socket.close();
        LogInfo.logs("Done sending message to the server");
    }

    public Message receiveMessageFromServer() throws IOException, EMCCommException, ClassNotFoundException {
        Message msg;
        block2: {
            LogInfo.logs("Receive message from the server");
            if (this.serverSocket == null) {
                this.serverSocket = new ServerSocket(this.bootstrapPort);
            }
            this.socket = this.serverSocket.accept();
            this.ois = new ObjectInputStream(this.socket.getInputStream());
            msg = null;
            this.timer.begin();
            do {
                if ((msg = (Message)this.ois.readObject()) != null) break block2;
            } while (!(this.timer.elapsedTimeInMinutes() > 10.0));
            throw new EMCCommException("Waited 10 minutes. No message received from the server");
        }
        LogInfo.logs("Received message from the server");
        this.ois.close();
        this.socket.close();
        this.serverSocket.close();
        this.serverSocket = null;
        return msg;
    }
}

