/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.main;

import com.google.common.collect.Lists;
import conifer.ml.CTMCExpFam;
import conifer.ml.main.Utils;
import fig.basic.Option;
import fig.basic.StrUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nuts.math.Graph;
import nuts.util.Indexer;

public class CTMCExpFamLoader {
    @Option
    public boolean isNormalized = true;
    @Option(gloss="Directory where the model specification files can be found")
    public String modelDirectory = ".";
    @Option(gloss="File containing the list of possible states, each indentified by a string")
    public String states = "states.json";
    @Option
    public String features = "features.json";
    @Option(gloss="File containing the support; full support if the corresponding file does not exist")
    public String support = "support.json";

    public CTMCExpFam<String> load() {
        Graph<String> supportGraph;
        ArrayList messages = Lists.newArrayList();
        Indexer<String> indexer = new Indexer<String>(Utils.statesFromJSON(new File(this.modelDirectory, this.states)));
        List<Utils.StateFeatureAssociation> featuresFromJSON = Utils.featuresFromJSON(new File(this.modelDirectory, this.features));
        messages.addAll(Utils.validateFeatures(featuresFromJSON, indexer));
        if (!new File(this.modelDirectory, this.support).exists()) {
            supportGraph = CTMCExpFam.completeGraph(indexer.objects());
        } else {
            List<List<String>> edges = Utils.edgesFromJSON(new File(this.modelDirectory, this.support));
            messages.addAll(Utils.validateEdges(edges, indexer));
            supportGraph = Utils.graph(edges, indexer.objects());
        }
        if (messages.size() > 0) {
            throw new RuntimeException("Errors prevented creation of CTMCExpFam");
        }
        CTMCExpFam<String> result = new CTMCExpFam<String>(supportGraph, indexer, this.isNormalized);
        result.extractReversibleBivariateFeatures(Collections.singleton(Utils.bivariateFeatureExtractor(featuresFromJSON)));
        result.extractUnivariateFeatures(Collections.singleton(Utils.univariateFeatureExtractor(featuresFromJSON)));
        return result;
    }

    public static class Exceptions
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public List<String> problems = new ArrayList<String>();

        public Exceptions(Exception e) {
            super(e);
            if (e instanceof Exceptions) {
                this.problems.addAll(((Exceptions)e).problems);
            } else {
                this.problems.add(e.toString());
            }
        }

        @Override
        public String toString() {
            return "Error(s):\n" + StrUtils.join(this.problems, "\n");
        }
    }
}

