/*
 * Decompiled with CFR 0.152.
 */
package conifer.pip.simple;

import java.util.ArrayList;
import java.util.List;

public class PIPString {
    public final List<Integer> characters;
    private int[] cachedPluses = null;
    private int cachedNZeroes = Integer.MIN_VALUE;

    public String toString() {
        return this.characters.toString();
    }

    public String toStars() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.characters.size(); ++i) {
            result.append("*");
        }
        return result.toString();
    }

    public int[] plusses() {
        this.ensurePlusZeroCache();
        return this.cachedPluses;
    }

    public int zeroes() {
        this.ensurePlusZeroCache();
        return this.cachedNZeroes;
    }

    private void ensurePlusZeroCache() {
        if (this.cachedPluses != null) {
            return;
        }
        this.cachedNZeroes = 0;
        for (int i : this.characters) {
            if (i != 0) continue;
            ++this.cachedNZeroes;
        }
        this.cachedPluses = new int[this.cachedNZeroes + 1];
        int curNPlus = 0;
        int interZeroIdx = 0;
        for (int curChar : this.characters) {
            if (curChar == 0) {
                this.cachedPluses[interZeroIdx] = curNPlus;
                curNPlus = 0;
                ++interZeroIdx;
                continue;
            }
            if (curChar == 1) {
                ++curNPlus;
                continue;
            }
            throw new RuntimeException();
        }
        this.cachedPluses[interZeroIdx] = curNPlus;
    }

    public PIPString(List<Integer> characters) {
        this.characters = characters;
    }

    public PIPString(String s) {
        String[] split = s.split("\\s+");
        this.characters = new ArrayList<Integer>();
        for (String str : split) {
            this.characters.add(Integer.parseInt(str));
        }
    }

    public PIPString(List<Integer> l1, Integer pt, List<Integer> l3) {
        this.characters = new ArrayList<Integer>();
        this.characters.addAll(l1);
        if (pt != null) {
            this.characters.add(pt);
        }
        this.characters.addAll(l3);
    }

    public PIPString(List<Integer> l1, List<Integer> l2) {
        this(l1, null, l2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.characters == null ? 0 : this.characters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PIPString other = (PIPString)obj;
        return !(this.characters == null ? other.characters != null : !this.characters.equals(other.characters));
    }
}

