/*
 * Decompiled with CFR 0.152.
 */
package conifer.tests;

import conifer.apps.Main;
import fig.exec.Execution;
import java.io.File;
import monaco.mcmc.MCAlgorithmType;
import nuts.io.IO;
import org.junit.Assert;
import org.junit.Test;

public class TestTemperingMultiThreads {
    @Test
    public void checkTemperingMultiThreads() {
        IO.run(new String[0], new TestTemperingMultiThreadsRunner());
    }

    private static Main getMain(String string, int nThreads) {
        Main result = new Main();
        File f = new File(Execution.getFile(string));
        f.mkdir();
        result.setOutputFolder(f);
        result.allOptions.proposalOptions.nGenerations = 200;
        result.allOptions.mcOptions.algorithm = MCAlgorithmType.TEMPERED_MCMC;
        result.allOptions.mcOptions.nTemperedChains = 4;
        result.allOptions.mcOptions.maxNThreads = nThreads;
        return result;
    }

    private static String getResultContents(String run) {
        File f = new File(Execution.getFile("" + run + "/tree-reconstructions/treeMetrics.csv"));
        return IO.f2s(f);
    }

    public static class TestTemperingMultiThreadsRunner
    implements Runnable {
        @Override
        public void run() {
            Main main1 = TestTemperingMultiThreads.getMain("run1", 4);
            Main main2 = TestTemperingMultiThreads.getMain("run2", 1);
            main1.run();
            main2.run();
            String[] lines1 = TestTemperingMultiThreads.getResultContents("run1").split("\n");
            String[] lines2 = TestTemperingMultiThreads.getResultContents("run2").split("\n");
            if (lines1.length != lines2.length) {
                throw new RuntimeException();
            }
            for (int i = 0; i < lines1.length; ++i) {
                String str1 = lines1[i].replaceAll(".*[,]", "");
                String str2 = lines2[i].replaceAll(".*[,]", "");
                System.out.println("Checking: " + str1 + " vs " + str2);
                Assert.assertEquals((Object)str1, (Object)str2);
            }
        }
    }
}

