/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.PairAlign;
import goblin.CognateId;
import goblin.Taxon;
import java.util.ArrayList;
import ma.BalibaseCorpus;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.util.CollUtils;

public class DistortionTest
implements Runnable {
    public static void main(String[] args) {
        IO.run(args, new DistortionTest(), "bali", PairAlign.options);
    }

    @Override
    public void run() {
        BalibaseCorpus bc = new BalibaseCorpus(PairAlign.options);
        for (CognateId id : bc.getMultiAlignments().keySet()) {
            MSAPoset gold = MSAPoset.fromMultiAlignmentObject(bc.getMultiAlignment(id));
            ArrayList<Taxon> taxa = CollUtils.list(gold.sequences().keySet());
            for (int i = 0; i < taxa.size(); ++i) {
                for (int j = i + 1; j < taxa.size(); ++j) {
                    Taxon s1 = (Taxon)taxa.get(i);
                    Taxon s2 = (Taxon)taxa.get(j);
                    System.out.println("Length ratio=" + (double)gold.sequences().get(s1).length() / (double)gold.sequences().get(s2).length());
                }
            }
        }
    }
}

