/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.DirSource;
import fig.exec.servlet.Exceptions;
import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecItem;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.View;

public abstract class ExecView
extends View<ExecItem> {
    private static int dividerIndex = 0;
    protected ExecFactory factory;

    public ExecView(Trail trail, FileSource source, ExecFactory factory) {
        this.trail = trail;
        this.source = source;
        this.factory = factory;
    }

    protected Field getField(String key, String gloss) {
        throw Exceptions.unknownCase();
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap(this.source.getFileView());
        fields.add(new Field("Count", "Number of executions"));
        fields.add(this.getField("description", "One-line description"));
        fields.add((Field)this.getField((String)"note", (String)"Random comments")).multiline = true;
        return fields;
    }

    @Override
    public FieldListMap getItemsFields() {
        DirSource allSource = (DirSource)this.source.getDomainView().getExecViewDB().getAllExecView().source;
        return this.factory.newExecItem(null, allSource).getMetadataFields();
    }

    @Override
    public UpdateQueue getPrioritizedItems(UpdateQueue.Priority priority) {
        UpdateQueue queue = new UpdateQueue();
        for (ExecItem item : this.getItems().values()) {
            if (item.isDivider() || item.immutable()) continue;
            queue.enqueue(item, !item.hasUpdated() || item.isRunning() ? priority : priority.next());
        }
        return queue;
    }

    @Override
    public ExecItem newDividerItem() {
        String name;
        while (this.items.containsKey(name = "DIVIDER" + dividerIndex++)) {
        }
        return this.factory.newDividerItem(name);
    }

    @Override
    public ExecItem newItem(String name) {
        return this.newDividerItem();
    }
}

