/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedMap;
import fig.exec.servlet.CompoundField;
import fig.exec.servlet.ConstantField;
import fig.exec.servlet.Field;
import fig.exec.servlet.FileView;
import fig.exec.servlet.MapFileField;
import java.util.ArrayList;

public class FieldListMap
extends OrderedMap<String, Field> {
    private FileView fileView;

    public FieldListMap() {
    }

    public FieldListMap(FileView fileView) {
        this.fileView = fileView;
    }

    public Field add(Field field) {
        String name = field.getName();
        if (name.equals("name")) {
            throw new RuntimeException("Reserved field name: " + name);
        }
        if (this.containsKey(field.getName())) {
            throw new RuntimeException("Duplicate field name: " + name);
        }
        this.put(name, field);
        return field;
    }

    public Field addWithObjs(String name, String gloss, Object[] objs) {
        Field field;
        if (objs.length == 1) {
            field = this.objToField(name, gloss, objs[0]);
            field.setGloss(gloss);
        } else {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Object obj : objs) {
                fields.add(this.objToField(null, null, obj));
            }
            field = new CompoundField(name, gloss, fields);
        }
        return this.add(field);
    }

    public Field add(String name, String gloss, Object ... objs) {
        return this.addWithObjs(name, gloss, objs);
    }

    private Field objToField(String name, String gloss, Object obj) {
        if (obj instanceof String) {
            Field field = MapFileField.parse(name, gloss, (String)obj, this.fileView);
            if (field != null) {
                return field;
            }
            return new ConstantField(name, gloss, obj);
        }
        if (obj instanceof Field) {
            return (Field)obj;
        }
        return new ConstantField(null, null, obj);
    }
}

