/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.CharEncUtils;
import fig.html.HtmlWriter;
import fig.servlet.RequestParams;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebState {
    public HtmlWriter hw;
    public RequestParams params;
    public HttpServletRequest request;
    public HttpServletResponse response;
    public HttpSession session;
    private static HttpServlet servlet;
    private static boolean loadedNew;
    public static boolean verbose;
    public static boolean logUpdates;
    public static boolean logWorkers;

    public WebState(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        this.session = request.getSession(true);
        this.params = new RequestParams(request);
        WebState.verboseLogs("============================================================");
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setRawOutput() {
    }

    public void setPlainOutput() {
        this.response.setContentType("text/plain; charset=" + CharEncUtils.getCharEncoding());
    }

    public void setHtmlOutput() {
        this.response.setContentType("text/html; charset=" + CharEncUtils.getCharEncoding());
    }

    public void initOutput() throws IOException {
        this.setHtmlOutput();
        this.hw = new HtmlWriter(this.getWriter());
    }

    public void endOutput() {
        this.hw.flush();
    }

    public static void setServlet(HttpServlet servlet) {
        WebState.servlet = servlet;
    }

    public static synchronized void logs(Object arg) {
        if (!loadedNew) {
            servlet.log("NEWLY LOADED JVM");
            loadedNew = true;
        }
        servlet.log("" + arg);
    }

    public static synchronized void logs(String format, Object ... args) {
        WebState.logs(String.format(format, args));
    }

    public static synchronized void verboseLogs(Object o) {
        if (verbose) {
            WebState.logs(o);
        }
    }

    public static synchronized void verboseLogs(String format, Object ... args) {
        if (verbose) {
            WebState.logs(format, args);
        }
    }
}

