/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.LogInfo;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nuts.maxent.BaseMeasures;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.maxent.MaxentClassifier;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.MathUtils;
import pepper.Edit;
import pepper.Effect;
import pepper.Encodings;
import pepper.Environment;
import pepper.editmodel.EditParam;
import pepper.editmodel.ParamUpdater;

public class GlobalMaxentUpdater<F>
implements ParamUpdater {
    private static final long serialVersionUID = 1L;
    private final Encodings enc;
    private GlobalHBaseMeasures mu;
    private double sigma = 1.0;
    private Set<Edit> allowedEdits = new HashSet<Edit>();
    private FeatureExtractor<LabeledInstance<Pair<Taxon, Environment>, Effect>, F> featureExtractor;
    private MaxentClassifier<Pair<Taxon, Environment>, Effect, F> classifier;
    private final int iterations;
    private final double tolerance;
    private double cutoff;
    private Counter<F> currentWeights = new Counter();

    public GlobalMaxentUpdater(Encodings enc, Collection<Edit> rules, FeatureExtractor<LabeledInstance<Pair<Taxon, Environment>, Effect>, F> featureExtractor, double sigma, int iterations, double tolerance, double cutoff) {
        this.enc = enc;
        this.sigma = sigma;
        this.tolerance = tolerance;
        this.iterations = iterations;
        this.cutoff = cutoff;
        this.mu = GlobalMaxentUpdater.baseMeasureFromAllowedRules(rules);
        this.allowedEdits.addAll(rules);
        this.allowedEdits = Collections.unmodifiableSet(this.allowedEdits);
        this.featureExtractor = featureExtractor;
    }

    @Override
    public void setSparsityStructure(Set<Edit> allowedEdits) {
        this.allowedEdits = new HashSet<Edit>();
        this.allowedEdits.addAll(allowedEdits);
        this.mu = GlobalMaxentUpdater.baseMeasureFromAllowedRules(allowedEdits);
    }

    @Override
    public Encodings getEncodings() {
        return this.enc;
    }

    @Override
    public Set<Edit> getSparsityStructure() {
        return this.allowedEdits;
    }

    @Override
    public Map<Taxon, EditParam> update(CounterMap<Taxon, Edit> expectedEditCounts, boolean viterbi) {
        if (!viterbi) {
            throw new UnsupportedOperationException();
        }
        Counter<LabeledInstance<Pair<Taxon, Environment>, Effect>> training = GlobalMaxentUpdater.convertCounts(expectedEditCounts);
        if (this.cutoff > 0.0) {
            throw new RuntimeException();
        }
        LogInfo.track("Learning maxent model from the sampled edits");
        Object learningOptions = null;
        throw new RuntimeException();
    }

    public String toString() {
        if (this.classifier == null) {
            return "MaxentParamUpdater: Not yet utilized";
        }
        return this.classifier.toString();
    }

    private EditParam fillEditParam(final Taxon currentLang, final MaxentClassifier<Pair<Taxon, Environment>, Effect, F> classifier) {
        return EditParam.createEditParam(this.enc, new EditParam.Initializer(){

            @Override
            public void process() {
                for (Environment env : Edit.allEnvironments(GlobalMaxentUpdater.this.enc)) {
                    Pair<Taxon, Environment> key = Pair.makePair(currentLang, env);
                    double[] prs = MathUtils.exp(classifier.logProb(key));
                    SortedSet effects = classifier.getLabels(key);
                    int i = 0;
                    for (Effect eff : effects) {
                        this.set(new Edit(GlobalMaxentUpdater.this.enc, env, eff), prs[i]);
                        ++i;
                    }
                }
            }
        });
    }

    private static Counter<LabeledInstance<Pair<Taxon, Environment>, Effect>> convertCounts(CounterMap<Taxon, Edit> allEdits) {
        Counter<LabeledInstance<Pair<Taxon, Environment>, Effect>> result = new Counter<LabeledInstance<Pair<Taxon, Environment>, Effect>>();
        for (Taxon lang : allEdits.keySet()) {
            Counter<Edit> src = allEdits.getCounter(lang);
            for (Edit srcCount : src.keySet()) {
                Environment env = srcCount.getEnvironment();
                Effect effect = srcCount.getEffect();
                Pair<Taxon, Environment> key = Pair.makePair(lang, env);
                LabeledInstance<Pair<Taxon, Environment>, Effect> labeledInstance = new LabeledInstance<Pair<Taxon, Environment>, Effect>(effect, key);
                assert (result.getCount(labeledInstance) == 0.0);
                result.setCount(labeledInstance, src.getCount(srcCount));
            }
        }
        return result;
    }

    public static GlobalHBaseMeasures baseMeasureFromAllowedRules(Collection<Edit> rules) {
        GlobalHBaseMeasures result = new GlobalHBaseMeasures();
        for (Edit edit : rules) {
            Environment env = edit.getEnvironment();
            Effect eff = edit.getEffect();
            TreeSet<Effect> baseMeasure = (TreeSet<Effect>)result.baseMeasures.get(env);
            if (baseMeasure == null) {
                baseMeasure = new TreeSet<Effect>();
                result.baseMeasures.put(env, baseMeasure);
            }
            baseMeasure.add(eff);
        }
        return result;
    }

    public static class GlobalHBaseMeasures
    implements BaseMeasures<Pair<Taxon, Environment>, Effect> {
        private static final long serialVersionUID = 1L;
        private final Map<Environment, SortedSet<Effect>> baseMeasures = new HashMap<Environment, SortedSet<Effect>>();

        @Override
        public SortedSet<Effect> support(Pair<Taxon, Environment> input) {
            SortedSet<Effect> result = this.baseMeasures.get(input.getSecond());
            if (result == null) {
                throw new RuntimeException();
            }
            return Collections.unmodifiableSortedSet(result);
        }
    }
}

