/*
 * Decompiled with CFR 0.152.
 */
package binc;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class BinCallUtils {
    private static String userHome = null;

    public static String userHomeFolder() {
        if (userHome != null) {
            return userHome;
        }
        userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new RuntimeException("Could not resolve the user folder");
        }
        if (!new File(userHome).exists()) {
            throw new RuntimeException("Incorrect home folder:" + userHome);
        }
        return userHome;
    }

    public static File resolveUserHome(String path) {
        if (path.contains("~/")) {
            path = path.replaceFirst("[~][/]", BinCallUtils.userHomeFolder() + "/");
        }
        return new File(path);
    }

    public static String toString(File f) {
        try {
            return Files.toString((File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFirstLine(File f) {
        try {
            return Files.readFirstLine((File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static void write(File f, CharSequence contents) {
        try {
            Files.write((CharSequence)contents, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

