/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateTreeNode;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import nuts.math.Graph;
import nuts.util.CollUtils;

public class CognateTreeGraph
implements Graph<CognateTreeNode> {
    private static final long serialVersionUID = 1L;
    private HashMap<Taxon, CognateTreeNode> nodes = CollUtils.map();

    @Override
    public Set<CognateTreeNode> nbrs(CognateTreeNode node) {
        return node.nbrs();
    }

    @Override
    public boolean hasEdge(CognateTreeNode node1, CognateTreeNode node2) {
        return node1.isNbr(node2);
    }

    @Override
    public Set<CognateTreeNode> vertexSet() {
        HashSet<CognateTreeNode> vertices = CollUtils.set();
        for (CognateTreeNode node : this.nodes.values()) {
            vertices.add(node);
        }
        return vertices;
    }

    public static CognateTreeGraph constructFullGraph(CognateTreeNode root) {
        CognateTreeGraph graph = new CognateTreeGraph();
        ArrayList<CognateTreeNode> preorder = CollUtils.list();
        CognateTreeNode.preorderTraversal(root, preorder);
        for (CognateTreeNode node : preorder) {
            graph.nodes.put(node.getTaxon(), node);
        }
        return graph;
    }

    public boolean hasNode(CognateTreeNode node) {
        return this.nodes.containsKey(node.getTaxon());
    }

    public void addNode(Taxon taxon, CognateTreeNode node) {
        this.nodes.put(node.getTaxon(), node);
    }
}

