/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateData;
import goblin.Taxon;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.util.CollUtils;

public class CognateTreeNode
implements Comparable<CognateTreeNode> {
    private Map<String, CognateData> data;
    private Taxon taxon;
    private CognateTreeNode left;
    private CognateTreeNode right;
    private CognateTreeNode parent;
    private int branchLength;
    private boolean isLeaf;

    public CognateTreeNode(Taxon taxon) {
        this.data = CollUtils.map();
        this.taxon = taxon;
        this.isLeaf = true;
    }

    public CognateTreeNode(CognateTreeNode left, CognateTreeNode right, int branchLength) {
        this.left = left;
        this.right = right;
        this.branchLength = branchLength;
        this.taxon = new Taxon("(" + left.getTaxon().toString() + ", " + right.getTaxon().toString() + ")");
        this.isLeaf = false;
    }

    public void setParent(CognateTreeNode parent) {
        this.parent = parent;
    }

    public Set<CognateTreeNode> nbrs() {
        HashSet<CognateTreeNode> nbrs = CollUtils.set();
        if (this.parent != null) {
            nbrs.add(this.parent);
        }
        if (this.left != null) {
            nbrs.add(this.left);
        }
        if (this.right != null) {
            nbrs.add(this.right);
        }
        return nbrs;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public CognateTreeNode getParentNode() {
        return this.parent;
    }

    public Set<CognateTreeNode> getChildrenNodes() {
        HashSet<CognateTreeNode> children = CollUtils.set();
        if (this.left != null) {
            children.add(this.left);
        }
        if (this.right != null) {
            children.add(this.right);
        }
        return children;
    }

    public CognateTreeNode getLeft() {
        return this.left;
    }

    public CognateTreeNode getRight() {
        return this.right;
    }

    public void addData(String gloss, CognateData datum) {
        if (this.data.containsKey(gloss)) {
            throw new RuntimeException();
        }
        this.data.put(gloss, datum);
    }

    public String getData(String gloss) {
        return this.data.get(gloss).getSequence();
    }

    public double[] getLikelihood(String gloss, int pos) {
        if (!this.isLeaf) {
            throw new RuntimeException();
        }
        return this.data.get(gloss).getLikelihood(pos);
    }

    public boolean isNbr(CognateTreeNode otherNode) {
        if (otherNode == null) {
            return false;
        }
        return otherNode == this.parent || otherNode == this.left || otherNode == this.right;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public static void preorderTraversal(CognateTreeNode node, List<CognateTreeNode> traversal) {
        traversal.add(node);
        if (node.left != null) {
            CognateTreeNode.preorderTraversal(node.left, traversal);
        }
        if (node.right != null) {
            CognateTreeNode.preorderTraversal(node.right, traversal);
        }
    }

    @Override
    public int compareTo(CognateTreeNode o) {
        return this.taxon.compareTo(o.taxon);
    }

    public String toString() {
        return this.taxon.toString();
    }
}

