/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import fig.basic.LogInfo;
import goblin.CognateId;
import java.util.Map;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.util.Counter;

public class PruningUpperBound
implements Runnable {
    public static void main(String[] args) {
        IO.run(args, new PruningUpperBound());
    }

    @Override
    public void run() {
        ExponentialFamily.ExponentialFamilyOptions expFamOptions = new ExponentialFamily.ExponentialFamilyOptions();
        expFamOptions.initParams = "e/251.exec/reest-block0-iter5.weights";
        FeatureExtractor.FeatureOptions featureOptions = new FeatureExtractor.FeatureOptions();
        featureOptions.useLongGaps = false;
        featureOptions.hydrophobicModeling = false;
        ExponentialFamily expFam = ExponentialFamily.createExpfam(null, expFamOptions, featureOptions, null);
        Map data = null;
        for (CognateId id : data.keySet()) {
            try {
                MSAPoset gold = (MSAPoset)data.get(id);
                LogInfo.track((Object)("Current id:" + id + " " + gold.sequences().keySet()), true);
                Counter<GreedyDecoder.Edge> posteriors = expFam.allPairsPosterior(((MSAPoset)data.get(id)).sequences());
                double nEdgesMax = posteriors.size();
                MSAPoset maxRecall = MSAPoset.maxRecallMSA(gold.sequences(), posteriors);
                LogInfo.track((Object)("Basic anneal score:" + MSAPoset.edgeRecall(gold, maxRecall) + " [" + maxRecall.edges().size() + " edges]"), true);
                LogInfo.end_track();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogInfo.error(e);
                e.printStackTrace();
            }
        }
    }
}

