/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.algo.FactorGraphInferenceAlgorithm;
import fenchel.factor.FactorGraph;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.factor.multisites.MSUnaryScaledFactor;
import fenchel.measurefacto.ExponentialFamily;
import hmm.RescaledBaumWelch;
import java.util.Set;

public class SingleNodeHMMs<N>
implements ExponentialFamily<MSUnaryMap<N>> {
    private final boolean useovercomplete;
    private final Set<N> nodes;
    private final double[][] trans;
    private final double[] init;

    public SingleNodeHMMs(Set<N> nodes2, double[] init2, double[][] trans2, boolean useovercomplete2) {
        this.nodes = nodes2;
        this.init = init2;
        this.trans = trans2;
        this.useovercomplete = useovercomplete2;
    }

    @Override
    public MSUnaryMap<N> moments(final MSUnaryMap<N> input) {
        if (!this.useovercomplete) {
            input.setLastStatesToOne();
        }
        return MSUnaryMap.fromMoments(new FactorGraphInferenceAlgorithm<N>(){

            @Override
            public void init(FactorGraph<N> factorGraph) {
                throw new RuntimeException();
            }

            @Override
            public UnaryFactor moment(N node) {
                double[][] currentInput = input.getUnaryArray(node);
                RescaledBaumWelch bw = new RescaledBaumWelch();
                bw.compute(SingleNodeHMMs.this.init, SingleNodeHMMs.this.trans, currentInput);
                double[][] moments = bw.allOneNodeMoments();
                return MSUnaryScaledFactor.buildFactor(moments);
            }

            @Override
            public double logZ() {
                throw new RuntimeException();
            }
        }, this.nodes, !this.useovercomplete);
    }
}

