/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import goblin.CognateSet;
import goblin.DerivationTree;
import goblin.EM;
import goblin.Heldout;
import goblin.ParamsTracker;
import goblin.ParamsTrackers;
import goblin.Taxon;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import nuts.io.Extensions;
import nuts.math.RejectionSampler;
import nuts.util.Arbre;
import nuts.util.CounterMap;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.ParamUpdater;
import pepper.editmodel.TreeSampler;
import pepper.editmodel.Utils;

public class EMMain
implements Runnable {
    public static final String AUTO_INIT = "!auto";
    @Option
    public String cognatesPath;
    @Option(gloss="empty string for no heldout")
    public String heldoutPath = "";
    @Option
    public String paramsInitPath = "!auto";
    @Option
    public String paramUpdaterPath;
    @Option(gloss="The number of complete sampling rounds per E iteration")
    public int nOuterSamplingIters = 3;
    @Option(gloss="Number of burn in iterations")
    public int nBurnInIters = 1;
    @Option
    public Random rand = new Random(1L);
    @Option
    public int emIters = 10;
    @Option
    public ArrayList<EM.FilterTypes> filterTypes = new ArrayList();
    @Option
    public int detailedBayesEvaluationEMonitoringIterations = 0;
    private RejectionSampler<Arbre<DerivationTree.DerivationNode>> rejectionSampler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Heldout heldout;
            Heldout heldout2 = heldout = this.heldoutPath.equals("") ? new Heldout(Taxon.dummy) : Heldout.restoreHeldout(this.heldoutPath);
            if (heldout == null) {
                heldout = new Heldout(Taxon.dummy);
            }
            ParamUpdater paramUpdaterFactory = Utils.restoreParamUpdater(this.paramUpdaterPath);
            ParamsTracker params = this.initParam(paramUpdaterFactory.getEncodings(), paramUpdaterFactory.getSparsityStructure());
            ParamsTrackers.saveParamsTracker(params, Utils.safeGetExecFilePath("initParam"));
            CognateSet cognates = CognateSet.restoreCognateSet(this.cognatesPath);
            EM em = null;
            LogInfo.logss("Initial average edit distance  : " + em.evaluate(heldout).averageOverWords());
            LogInfo.logss("Random baseline average edit distance : " + heldout.randomBaseline(cognates, this.rand).averageOverWords());
            LogInfo.logss("Oracle baseline average edit distance : " + heldout.oracleBaseline(cognates).averageOverWords());
            for (int i = 0; i < this.emIters; ++i) {
                LogInfo.track((Object)("EM iteration " + i), true);
                try {
                    Heldout heldout3 = heldout;
                    heldout3.getClass();
                    Heldout.BayesEvaluator bayesEvaluator = new Heldout.BayesEvaluator(heldout3, cognates);
                    ParamsTracker paramsTracker = em.getCurrentParams();
                    Heldout heldout4 = heldout;
                    heldout4.getClass();
                    em.detailedBayesEvaluationEMonitoring(paramsTracker, this.detailedBayesEvaluationEMonitoringIterations, this.rand, new Heldout.BayesEvaluator(heldout4, cognates));
                    em.compute(this.rand, this.nOuterSamplingIters, this.nBurnInIters, bayesEvaluator);
                    Heldout.WordHeldoutEvaluation pointEval = em.evaluate(heldout);
                    Heldout.WordHeldoutEvaluation bayesEval = bayesEvaluator.evaluate();
                    Heldout.saveHeldoutEvaluation(pointEval, EMMain.addIterExtension(Utils.safeGetExecFilePath("eval"), i));
                    Heldout.saveBayesEvaluator(bayesEvaluator, EMMain.addIterExtension(Utils.safeGetExecFilePath("bayesevaluator.seri"), i));
                    LogInfo.logss("Current average edit distance (point): " + pointEval.averageOverWords());
                    LogInfo.logss("Current average edit distance (bayes): " + bayesEval.averageOverWords());
                    if (em.isLogLikelihoodAvailable()) {
                        LogInfo.logss("Current loglikelihood: " + em.getLogLikelihood());
                    }
                    EMMain.dumpEditStat(em.getCurrentEdits(), i);
                    EMMain.dumpStat(EMMain.addIterExtension("bayesevaluator.string", i), bayesEvaluator);
                    ParamsTrackers.saveParamsTracker(em.getCurrentParams(), EMMain.addIterExtension(Utils.safeGetExecFilePath("params"), i));
                    CognateSet.saveCognateSet(em.getCognates(), EMMain.addIterExtension(Utils.safeGetExecFilePath("words"), i));
                    continue;
                }
                finally {
                    LogInfo.end_track();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dumpEditStat(CounterMap<Taxon, Edit> edits, int iter) throws IOException {
    }

    public static void dumpStat(String name, Object ... stats) {
        if (stats == null) {
            return;
        }
        String fileName = Utils.safeGetExecFilePath(name);
        try (PrintWriter out = null;){
            out = IOUtils.openOut(fileName);
            for (Object stat : stats) {
                out.append(stat.toString());
                out.append("\n");
            }
            LogInfo.logs("Dumping stats in " + fileName);
        }
    }

    public static void dumpStat(String name, int iter, Object ... stats) throws IOException {
        EMMain.dumpStat(EMMain.addIterExtension(name, iter), stats);
    }

    public static String addIterExtension(String path, int iter) {
        return path + "." + Extensions.extension2String(iter);
    }

    private ParamsTracker initParam(Encodings enc, Set<Edit> sparseStruct) throws IOException, ClassNotFoundException {
        if (this.paramsInitPath.equals(AUTO_INIT)) {
            return new ParamsTrackers.HomoParamsTracker(TreeSampler.initEditParam(enc, sparseStruct, 1.0, 90.0, 7.0, 2.0, false));
        }
        ParamsTracker result = ParamsTrackers.restoreParamsTracker(this.paramsInitPath);
        if (!result.getEncodings().equals(enc)) {
            throw new RuntimeException();
        }
        return result;
    }
}

