/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.BayesRiskMinimizer;
import goblin.CognateId;
import goblin.CognateSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.inference.TestUtils;

public class ReadEval {
    public static Map<CognateId, Evaluation> read(String file) {
        HashMap<CognateId, Evaluation> result = new HashMap<CognateId, Evaluation>();
        Evaluation cEval = new Evaluation();
        for (String line : IO.i(file)) {
            String recon;
            String[] fields = line.split("\\s+");
            if (fields[0].equals("ID")) {
                cEval.id = new CognateId(fields[1]);
                continue;
            }
            if (fields[0].equals("TRUTH")) {
                cEval.truth = fields.length < 2 ? "" : fields[1];
                continue;
            }
            if (fields[0].equals("LOSS")) {
                cEval.loss = BayesRiskMinimizer.levenshteinLoss.loss(cEval.truth, cEval.recon);
                result.put(cEval.id, cEval);
                cEval = new Evaluation();
                continue;
            }
            if (line.equals("----") || line.matches("Average loss (per word).*")) continue;
            cEval.recon = recon = fields.length == 2 ? fields[1] : "";
            cEval.system = fields[0];
        }
        return result;
    }

    public static Map<CognateId, Evaluation> readOld(String file, Collection<Evaluation> otherEval) {
        HashMap<CognateId, Evaluation> result = new HashMap<CognateId, Evaluation>();
        Evaluation cEval = new Evaluation();
        for (String line : IO.i(file)) {
            try {
                if (line.contains("Correct word")) {
                    cEval.truth = StringUtils.selectRegex("^[^:]* [:] (.*)$", line).get(0);
                    continue;
                }
                if (line.matches(".*System's reconstr.*dist.*")) {
                    cEval.recon = StringUtils.selectRegex("^[^:]* [:] ([^.]+)\\s.*$", line).get(0);
                    continue;
                }
                if (!line.matches(".*Initial baseline.*dist.*")) continue;
                cEval.loss = BayesRiskMinimizer.levenshteinLoss.loss(cEval.truth, cEval.recon);
                cEval.system = "OLD";
                cEval.id = ReadEval.findId(cEval.truth, otherEval);
                if (cEval.id != null) {
                    result.put(cEval.id, cEval);
                }
                cEval = new Evaluation();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Bad line:" + line);
            }
        }
        return result;
    }

    private static CognateId findId(String truth, Collection<Evaluation> otherEval) {
        CognateId result = null;
        for (Evaluation eval : otherEval) {
            if (!eval.truth.equals(truth)) continue;
            if (result != null) {
                System.err.println("WARNING: Another cognate set had gold:" + truth);
                continue;
            }
            result = eval.id;
        }
        return result;
    }

    public static void main(String[] args) throws IllegalArgumentException, MathException, IOException, ClassNotFoundException {
        Map<CognateId, Evaluation> evals2;
        if (args.length < 2) {
            System.out.println("goblin.ReadEval <path_to_sys_1> <path_to_sys_2> [o |s |c |v ]* [<path_to_.CognateSet>]");
            System.out.println("\to: second system treated as Old format");
            System.out.println("\ts: Show only entries where syst 1 loss < syst 2 loss");
            System.out.println("\td: just Compare the keys (truth)");
            System.out.println("\tt: output in csV format");
            return;
        }
        boolean oOpt = Arrays.asList(args).contains("o");
        boolean sOpt = Arrays.asList(args).contains("s");
        boolean tOpt = Arrays.asList(args).contains("v");
        String f1 = args[0];
        String f2 = args[1];
        if (tOpt && sOpt) {
            throw new RuntimeException();
        }
        Map<CognateId, Evaluation> evals1 = ReadEval.read(f1);
        Map<CognateId, Evaluation> map = evals2 = oOpt ? ReadEval.readOld(f2, evals1.values()) : ReadEval.read(f2);
        if (Arrays.asList(args).contains("d")) {
            for (CognateId key : CollUtils.union(evals1.keySet(), evals2.keySet())) {
                IO.so(key + "\t" + (evals1.keySet().contains(key) ? "sys_1" : "") + (evals2.keySet().contains(key) ? "sys_2" : ""));
            }
            return;
        }
        CognateSet cs = null;
        if (args[args.length - 1].matches(".*[.]CognateSet")) {
            cs = CognateSet.restoreCognateSet(args[args.length - 1]);
        }
        if (!evals1.keySet().equals(evals2.keySet())) {
            System.err.println("WARNING: key sets (gold words) not equal... intersecting");
        }
        HashSet<CognateId> inter = new HashSet<CognateId>(evals1.keySet());
        inter.retainAll(evals2.keySet());
        DescriptiveStatistics stat1 = new DescriptiveStatistics();
        DescriptiveStatistics stat2 = new DescriptiveStatistics();
        DescriptiveStatistics normstat1 = new DescriptiveStatistics();
        DescriptiveStatistics normstat2 = new DescriptiveStatistics();
        String sys1 = evals1.values().iterator().next().system;
        String sys2 = evals2.values().iterator().next().system;
        if (tOpt) {
            IO.so("gloss,gold,\"" + sys1 + "\",\"" + sys1 + "-dist\",\"" + sys2 + "\",\"" + sys2 + "-dist\"");
        }
        for (CognateId id : inter) {
            Evaluation eval1 = evals1.get(id);
            Evaluation eval2 = evals2.get(id);
            stat1.addValue(eval1.loss);
            stat2.addValue(eval2.loss);
            normstat1.addValue(eval1.loss / (double)eval1.truth.length());
            normstat2.addValue(eval2.loss / (double)eval2.truth.length());
            if (tOpt) {
                IO.so("\"" + id + "\"," + eval1.truth + "," + eval1.recon + "," + eval1.loss + "," + eval2.recon + "," + eval2.loss);
                continue;
            }
            if (!(eval1.loss < eval2.loss) && sOpt) continue;
            IO.so("Id:" + id + "\n" + "Truth:" + eval1.truth + "\n" + eval1.system + " " + eval1.recon + " (" + eval1.loss + ")\n" + eval2.system + " " + eval2.recon + " (" + eval2.loss + ")\n" + (cs == null ? "" : cs.toString(id) + "\n") + "----\n");
        }
        if (tOpt) {
            IO.so("AVERAGES,,," + stat1.getMean() + ",," + stat2.getMean());
        } else {
            IO.so("\n");
            IO.so("Mean loss of " + sys1 + ":" + stat1.getMean() + " (norm:" + normstat1.getMean() + ")");
            IO.so("Mean loss of " + sys2 + ":" + stat2.getMean() + " (norm:" + normstat2.getMean() + ")");
            IO.so("p-value:" + TestUtils.pairedTTest((double[])stat1.getValues(), (double[])stat2.getValues()));
        }
    }

    public static class Evaluation {
        public String truth;
        public String recon;
        public String system;
        public CognateId id;
        public double loss;

        public String toString() {
            return "ID " + this.id + "\n" + "TRUTH " + this.truth + "\n" + this.system + " " + this.recon + "\n" + "LOSS " + this.loss;
        }
    }
}

