/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import fig.basic.LogInfo;
import fig.basic.Option;
import nuts.io.IO;
import parallel.Ising;

public class GibbsIsing
implements Runnable {
    @Option
    public int MAX_ITER = 1000000;
    @Option
    public int L = 3;
    @Option
    public double alpha = 0.0;
    @Option
    public double T = 2.0;

    @Override
    public void run() {
        Ising model = new Ising(this.L, this.alpha, this.T, 0);
        int numIter = 0;
        int numWhite = 0;
        int numBlack = 0;
        do {
            model.parallelStep();
            ++numIter;
            if (model.countSpins() == this.L * this.L) {
                ++numWhite;
                continue;
            }
            if (model.countSpins() != -this.L * this.L) continue;
            ++numBlack;
        } while (numIter != this.MAX_ITER);
        LogInfo.logs("Num iter=" + numIter);
        LogInfo.logs("Num White=" + numWhite + " Num Black=" + numBlack);
        model.printPosterior();
    }

    public static void main(String[] args) {
        IO.run(args, new GibbsIsing());
    }
}

