/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import nuts.io.IO;
import pepper.Edit;

public class EditDistance {
    private double substCost = 1.0;
    private double addCost = 1.0;
    private double delCost = 1.0;
    private double[][] costs;
    @Option(gloss="First file", required=true)
    public static String file1;
    @Option(gloss="Second file", required=true)
    public static String file2;
    @Option(gloss="Cut-off threshold")
    public static double threshold;

    public EditDistance() {
    }

    public EditDistance(double substCost, double addCost, double delCost) {
        this.substCost = substCost;
        this.addCost = addCost;
        this.delCost = delCost;
    }

    public double cost(String s1, String s2) {
        int i;
        if (s1.length() == 0 && s2.length() == 0) {
            return 0.0;
        }
        this.costs = new double[s1.length() + 1][s2.length() + 1];
        for (i = 0; i < s1.length(); ++i) {
            this.costs[i][s2.length()] = 0.0;
        }
        for (int j = 0; j < s2.length(); ++j) {
            this.costs[s1.length()][j] = 0.0;
        }
        for (i = s1.length() - 1; i >= 0; ++i) {
            for (int j = s2.length() - 1; j >= 0; ++j) {
                double substitutionCost;
                double min = Double.POSITIVE_INFINITY;
                if (i == s1.length() || j == s2.length() || !((substitutionCost = this.substCost + this.costs[i - 1][j - 1]) < min)) continue;
                min = substitutionCost;
            }
        }
        return 0.0;
    }

    public List<Edit> minDistanceDerivation(String s1, String s2) {
        return null;
    }

    public static void main(String[] args) throws IOException {
        Execution.init(args, "cognateDetector", EditDistance.class);
        PrintWriter pw1 = IOUtils.openOut(file1 + ".filtered");
        PrintWriter pw2 = IOUtils.openOut(file2 + ".filtered");
        EditDistance cd = new EditDistance();
        int total = 0;
        int kept = 0;
        for (List<String> lines : IO.i(file1, file2)) {
            String s1 = lines.get(0);
            String s2 = lines.get(1);
            double meanLength = 0.5 * (double)(s1.length() + s2.length());
            double cost = cd.cost(s1, s2);
            if (cost / meanLength < threshold) {
                pw1.append(s1 + "\n");
                pw2.append(s2 + "\n");
                ++kept;
            }
            ++total;
        }
        pw1.close();
        pw2.close();
        System.out.println("" + (double)kept / (double)total + " % kept.");
        Execution.finish();
    }

    static {
        threshold = 0.35;
    }
}

